/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xml.ElementImplSerializer;
import tigase.halcyon.core.xml.EscapeUtils;
import tigase.halcyon.core.xml.XmlException;

@Serializable(with=ElementImplSerializer.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0016J\u0006\u0010\u001c\u001a\u00020\u001aJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J#\u0010!\u001a\u0004\u0018\u00010\u00012\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030#\"\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001eH\u0016J\u0010\u0010)\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\n\u0010,\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010.\u001a\u00020'H\u0016J\u0010\u0010/\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u00100\u001a\u00020\u0003H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0004R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000e\u00a8\u00062"}, d2={"Ltigase/halcyon/core/xml/ElementImpl;", "Ltigase/halcyon/core/xml/Element;", "name", "", "(Ljava/lang/String;)V", "attributes", "", "getAttributes", "()Ljava/util/Map;", "children", "", "getChildren", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "parent", "getParent", "()Ltigase/halcyon/core/xml/Element;", "setParent", "(Ltigase/halcyon/core/xml/Element;)V", "value", "getValue", "setValue", "xmlns", "getXmlns", "add", "", "child", "detach", "equals", "", "other", "", "findChild", "elemPath", "", "([Ljava/lang/String;)Ltigase/halcyon/core/xml/Element;", "getAsString", "deep", "", "showValue", "getChildAfter", "", "getChildrenNS", "getFirstChild", "getNextSibling", "hashCode", "remove", "toString", "Companion", "halcyon-core"})
public final class ElementImpl
implements Element {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @Nullable
    private Element parent;
    @NotNull
    private final List<Element> children;
    @NotNull
    private final Map<String, String> attributes;
    @Nullable
    private String value;

    public ElementImpl(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
        this.children = new ArrayList();
        this.attributes = new HashMap();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Element element2) {
        this.parent = element2;
    }

    @Override
    @NotNull
    public List<Element> getChildren() {
        return this.children;
    }

    @Override
    @NotNull
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public String getXmlns() {
        return this.getAttributes().get("xmlns");
    }

    @Override
    @Nullable
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(@Nullable String string) {
        this.value = string;
    }

    @Override
    @Nullable
    public Element findChild(String ... elemPath) {
        String str;
        Intrinsics.checkNotNullParameter((Object)elemPath, (String)"elemPath");
        Element child = this;
        if (elemPath.length == 0) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)elemPath[0], (Object)this.getName())) {
            return null;
        }
        for (int i = 1; i < elemPath.length && child != null; child = child.getFirstChild(str), ++i) {
            str = elemPath[i];
        }
        return child;
    }

    @Override
    @Nullable
    public Element getFirstChild() {
        return !this.getChildren().isEmpty() ? (Element)CollectionsKt.first(this.getChildren()) : (Element)null;
    }

    @Override
    @Nullable
    public Element getFirstChild(@NotNull String name2) {
        Element element2;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (!this.getChildren().isEmpty()) {
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = this.getChildren();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Element element3 = (Element)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)element3.getName(), (Object)name2)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            element2 = v0;
        } else {
            element2 = null;
        }
        return element2;
    }

    @Override
    @NotNull
    public Element getChildAfter(@NotNull Element child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        int index = this.getChildren().indexOf(child);
        if (index == -1) {
            throw new XmlException("Element not part of tree");
        }
        return this.getChildren().get(index + 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Element> getChildren(@NotNull String name2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$filter$iv = this.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element element2 = (Element)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)element2.getName(), (Object)name2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Element> getChildrenNS(@NotNull String xmlns2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)xmlns2, (String)"xmlns");
        Iterable $this$filter$iv = this.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element element2 = (Element)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)element2.getXmlns(), (Object)xmlns2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Element getChildrenNS(@NotNull String name2, @NotNull String xmlns2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)xmlns2, (String)"xmlns");
            Iterable $this$firstOrNull$iv = this.getChildren();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Element element2 = (Element)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)element2.getName(), (Object)name2) && Intrinsics.areEqual((Object)element2.getXmlns(), (Object)xmlns2))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Nullable
    public Element getNextSibling() {
        Element element2 = this.getParent();
        return element2 != null ? element2.getChildAfter(this) : null;
    }

    @Override
    public void remove(@NotNull Element child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        child.setParent(null);
        this.getChildren().remove(child);
    }

    @Override
    public void add(@NotNull Element child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        child.setParent(this);
        this.getChildren().add(child);
    }

    public final void detach() {
        block0: {
            Element element2 = this.getParent();
            if (element2 == null) break block0;
            Element it = element2;
            boolean bl = false;
            it.remove(this);
            this.setParent(null);
        }
    }

    @Override
    @NotNull
    public String getAsString(int deep, boolean showValue) {
        StringBuilder builder2;
        block13: {
            block14: {
                builder2 = new StringBuilder();
                builder2.append('<');
                builder2.append(this.getName());
                if (this.getXmlns() == null) break block13;
                if (this.getParent() == null) break block14;
                Element element2 = this.getParent();
                if ((element2 != null ? element2.getXmlns() : null) == null) break block14;
                Element element3 = this.getParent();
                if (StringsKt.equals$default((String)(element3 != null ? element3.getXmlns() : null), (String)this.getXmlns(), (boolean)false, (int)2, null)) break block13;
            }
            builder2.append(' ');
            builder2.append("xmlns=\"");
            builder2.append(EscapeUtils.Companion.escape(this.getXmlns()));
            builder2.append('\"');
        }
        for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
            String key = entry.getKey();
            String value1 = entry.getValue();
            if (Intrinsics.areEqual((Object)key, (Object)"xmlns")) continue;
            builder2.append(' ');
            builder2.append(key);
            builder2.append("=\"");
            builder2.append(EscapeUtils.Companion.escape(value1));
            builder2.append('\"');
        }
        if (this.getChildren().isEmpty() && this.getValue() == null) {
            builder2.append('/');
        }
        builder2.append('>');
        if (deep > 0) {
            for (Element element4 : this.getChildren()) {
                builder2.append(element4.getAsString(deep - 1, showValue));
            }
        } else if (!this.getChildren().isEmpty()) {
            builder2.append("...");
        }
        if (this.getValue() != null) {
            if (showValue) {
                builder2.append(EscapeUtils.Companion.escape(this.getValue()));
            } else {
                builder2.append("...");
            }
        }
        if (!this.getChildren().isEmpty() || this.getValue() != null) {
            builder2.append("</");
            builder2.append(this.getName());
            builder2.append('>');
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof Element) {
            if (!Intrinsics.areEqual((Object)this.getName(), (Object)((Element)other).getName())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getValue(), (Object)((Element)other).getValue())) {
                return false;
            }
            if (!Intrinsics.areEqual(this.getAttributes(), ((Element)other).getAttributes())) {
                return false;
            }
            if (this.getChildren().size() != ((Element)other).getChildren().size()) {
                return false;
            }
            int n = this.getChildren().size();
            for (int i = 0; i < n; ++i) {
                if (this.getChildren().get(i).equals(((Element)other).getChildren().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return (this.getName() + "::" + this.getAttributes().size() + "::" + new PropertyReference0Impl(this.getChildren()){

            @Nullable
            public Object get() {
                return ((List)this.receiver).size();
            }
        } + "::" + this.getAttributes().get("id")).hashCode();
    }

    @NotNull
    public String toString() {
        return "XMLElement[name='" + this.getName() + "' hash='" + this.hashCode() + "']";
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Ltigase/halcyon/core/xml/ElementImpl$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Ltigase/halcyon/core/xml/ElementImpl;", "halcyon-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ElementImpl> serializer() {
            return ElementImplSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

