/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import korlibs.crypto.SHA1Kt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Context;
import tigase.halcyon.core.Scope;
import tigase.halcyon.core.connector.SessionController;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.logger.Level;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.modules.Criteria;
import tigase.halcyon.core.modules.Criterion;
import tigase.halcyon.core.modules.ModulesManager;
import tigase.halcyon.core.modules.XmppModule;
import tigase.halcyon.core.modules.XmppModuleProvider;
import tigase.halcyon.core.xml.BuilderKt;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xml.ElementNode;
import tigase.halcyon.core.xmpp.ErrorCondition;
import tigase.halcyon.core.xmpp.XMPPException;
import tigase.halcyon.core.xmpp.modules.auth.AuthData;
import tigase.halcyon.core.xmpp.modules.auth.ClientSaslException;
import tigase.halcyon.core.xmpp.modules.auth.DeviceNameKt;
import tigase.halcyon.core.xmpp.modules.auth.InlineFeatures;
import tigase.halcyon.core.xmpp.modules.auth.InlineProtocol;
import tigase.halcyon.core.xmpp.modules.auth.InlineProtocolStage;
import tigase.halcyon.core.xmpp.modules.auth.InlineResponse;
import tigase.halcyon.core.xmpp.modules.auth.SASL2ModuleConfig;
import tigase.halcyon.core.xmpp.modules.auth.SASLEngine;
import tigase.halcyon.core.xmpp.modules.auth.SASLEvent;
import tigase.halcyon.core.xmpp.modules.auth.SASLModule;
import tigase.halcyon.core.xmpp.modules.auth.SASLPlain;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA1;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA256;
import tigase.halcyon.core.xmpp.modules.auth.State;
import tigase.halcyon.core.xmpp.modules.discovery.DiscoveryModule;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010!\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020%H\u0016J\u0010\u0010(\u001a\u00020\"2\u0006\u0010'\u001a\u00020%H\u0002J\u0010\u0010)\u001a\u00020\"2\u0006\u0010'\u001a\u00020%H\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010'\u001a\u00020%H\u0002J\u000e\u0010+\u001a\u00020\"2\u0006\u0010$\u001a\u00020%R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/SASL2Module;", "Ltigase/halcyon/core/modules/XmppModule;", "Ltigase/halcyon/core/xmpp/modules/auth/SASL2ModuleConfig;", "context", "Ltigase/halcyon/core/Context;", "discoveryModule", "Ltigase/halcyon/core/xmpp/modules/discovery/DiscoveryModule;", "(Ltigase/halcyon/core/Context;Ltigase/halcyon/core/xmpp/modules/discovery/DiscoveryModule;)V", "getContext", "()Ltigase/halcyon/core/Context;", "criteria", "Ltigase/halcyon/core/modules/Criteria;", "getCriteria", "()Ltigase/halcyon/core/modules/Criteria;", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "engine", "Ltigase/halcyon/core/xmpp/modules/auth/SASLEngine;", "features", "", "", "getFeatures", "()[Ljava/lang/String;", "[Ljava/lang/String;", "log", "Ltigase/halcyon/core/logger/Logger;", "type", "getType", "()Ljava/lang/String;", "initialize", "", "isAllowed", "streamFeatures", "Ltigase/halcyon/core/xml/Element;", "process", "element", "processChallenge", "processFailure", "processSuccess", "startAuth", "Companion", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nSASL2Module.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SASL2Module.kt\ntigase/halcyon/core/xmpp/modules/auth/SASL2Module\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n766#2:143\n857#2,2:144\n1603#2,9:146\n1855#2:155\n1856#2:157\n1612#2:158\n800#2,11:159\n1855#2,2:170\n1#3:156\n*S KotlinDebug\n*F\n+ 1 SASL2Module.kt\ntigase/halcyon/core/xmpp/modules/auth/SASL2Module\n*L\n64#1:143\n64#1:144,2\n64#1:146,9\n64#1:155\n64#1:157\n64#1:158\n107#1:159,11\n107#1:170,2\n64#1:156\n*E\n"})
public final class SASL2Module
implements XmppModule,
SASL2ModuleConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final DiscoveryModule discoveryModule;
    @NotNull
    private final Logger log;
    @NotNull
    private final String type;
    @NotNull
    private final Criteria criteria;
    @Nullable
    private final String[] features;
    @NotNull
    private final SASLEngine engine;
    private boolean enabled;
    @NotNull
    public static final String XMLNS = "urn:xmpp:sasl:2";
    @NotNull
    private static final String TYPE = "tigase.halcyon.core.xmpp.modules.auth.SASL2Module";

    public SASL2Module(@NotNull Context context, @NotNull DiscoveryModule discoveryModule) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)discoveryModule, (String)"discoveryModule");
        this.context = context;
        this.discoveryModule = discoveryModule;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.xmpp.modules.auth.SASL2Module", false, 2, null);
        this.type = TYPE;
        Criteria[] criteriaArray = new Criteria[]{Criterion.Companion.nameAndXmlns("success", XMLNS), Criterion.Companion.nameAndXmlns("failure", XMLNS), Criterion.Companion.nameAndXmlns("challenge", XMLNS)};
        this.criteria = Criterion.Companion.or(criteriaArray);
        this.engine = new SASLEngine(this.getContext());
        this.enabled = true;
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    @Nullable
    public String[] getFeatures() {
        return this.features;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private final void initialize() {
        this.engine.add(new SASLScramSHA256(null, 1, null));
        this.engine.add(new SASLScramSHA1(null, 1, null));
        this.engine.add(new SASLPlain());
    }

    /*
     * WARNING - void declaration
     */
    public final void startAuth(@NotNull Element streamFeatures) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)streamFeatures, (String)"streamFeatures");
        Element element2 = streamFeatures.getChildrenNS("authentication", XMLNS);
        if (element2 == null) {
            throw new HalcyonException("No SASL2 features in stream.");
        }
        Element saslStreamFeatures = element2;
        Iterable $this$filter$iv = saslStreamFeatures.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element it = (Element)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"mechanism")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element it = (Element)element$iv$iv;
            boolean bl2 = false;
            if (it.getValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List allowedMechanisms = (List)destination$iv$iv;
        AuthData authData = this.engine.start(allowedMechanisms);
        Element authElement2 = BuilderKt.element("authenticate", (Function1<? super ElementNode, Unit>)((Function1)new Function1<ElementNode, Unit>(authData, saslStreamFeatures, this){
            final /* synthetic */ AuthData $authData;
            final /* synthetic */ Element $saslStreamFeatures;
            final /* synthetic */ SASL2Module this$0;
            {
                this.$authData = $authData;
                this.$saslStreamFeatures = $saslStreamFeatures;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ElementNode $this$element) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$element, (String)"$this$element");
                $this$element.setXmlns("urn:xmpp:sasl:2");
                $this$element.attribute("mechanism", this.$authData.getMechanismName());
                $this$element.invoke("initial-response", new Pair[0], (Function1<? super ElementNode, Unit>)((Function1)new Function1<ElementNode, Unit>(this.$authData){
                    final /* synthetic */ AuthData $authData;
                    {
                        this.$authData = $authData;
                        super(1);
                    }

                    public final void invoke(@NotNull ElementNode $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                        if (this.$authData.getData() != null) {
                            $this$invoke.unaryPlus(this.$authData.getData());
                        }
                    }
                }));
                $this$element.invoke("user-agent", new Pair[0], (Function1<? super ElementNode, Unit>)((Function1)new Function1<ElementNode, Unit>(this.this$0){
                    final /* synthetic */ SASL2Module this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ElementNode $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                        String softwareName = SASL2Module.access$getDiscoveryModule$p(this.this$0).getClientName();
                        String deviceName = DeviceNameKt.getDeviceName();
                        $this$invoke.getAttributes().set("id", SHA1Kt.sha1((byte[])StringsKt.encodeToByteArray((String)(softwareName + ":" + deviceName))).getHex());
                        $this$invoke.invoke("software", new Pair[0], (Function1<? super ElementNode, Unit>)((Function1)new Function1<ElementNode, Unit>(softwareName){
                            final /* synthetic */ String $softwareName;
                            {
                                this.$softwareName = $softwareName;
                                super(1);
                            }

                            public final void invoke(@NotNull ElementNode $this$invoke) {
                                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                $this$invoke.unaryPlus(this.$softwareName);
                            }
                        }));
                        $this$invoke.invoke("device", new Pair[0], (Function1<? super ElementNode, Unit>)((Function1)new Function1<ElementNode, Unit>(deviceName){
                            final /* synthetic */ String $deviceName;
                            {
                                this.$deviceName = $deviceName;
                                super(1);
                            }

                            public final void invoke(@NotNull ElementNode $this$invoke) {
                                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                $this$invoke.unaryPlus(this.$deviceName);
                            }
                        }));
                    }
                }));
                InlineFeatures saslInlineFeatures = InlineFeatures.Companion.create(this.$saslStreamFeatures);
                Iterable $this$filterIsInstance$iv = this.this$0.getContext().getModules().getModules();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof InlineProtocol)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Element it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    InlineProtocol it = (InlineProtocol)element$iv$iv;
                    boolean bl2 = false;
                    if (it.featureFor(saslInlineFeatures, InlineProtocolStage.AfterSasl) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (E element$iv : $this$forEach$iv) {
                    Element it = (Element)element$iv;
                    boolean bl = false;
                    $this$element.addChild(it);
                }
            }
        }));
        this.getContext().getWriter().writeDirectly(authElement2);
    }

    @Override
    public void process(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        try {
            switch (element2.getName()) {
                case "success": {
                    this.processSuccess(element2);
                    break;
                }
                case "failure": {
                    this.processFailure(element2);
                    break;
                }
                case "challenge": {
                    this.processChallenge(element2);
                    break;
                }
                default: {
                    throw new XMPPException(ErrorCondition.BadRequest, "Unsupported element");
                }
            }
        }
        catch (ClientSaslException e) {
            this.engine.getSaslContext().setState$halcyon_core(State.Failed);
            this.getContext().getEventBus().fire(new SASLEvent.SASLError(SASLModule.SASLError.Unknown, e.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processSuccess(Element element2) {
        Element element3 = element2.getFirstChild("additional-data");
        this.engine.evaluateSuccess(element3 != null ? element3.getValue() : null);
        try {
            void $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            InlineResponse response = new InlineResponse(InlineProtocolStage.AfterSasl, element2);
            boolean bl = false;
            Iterable $this$filterIsInstance$iv = this.getContext().getModules().getModules();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof InlineProtocol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InlineProtocol consumer = (InlineProtocol)element$iv;
                boolean bl2 = false;
                consumer.process(response);
            }
        }
        catch (Throwable e) {
            this.log.log(Level.SEVERE, "Error during inline processing: " + e.getMessage(), e);
            this.getContext().getEventBus().fire(new SessionController.SessionControllerEvents.ErrorStop("Error during inline processing: " + e.getMessage()));
        }
    }

    private final void processFailure(Element element2) {
        Element element3 = element2.getFirstChild();
        Intrinsics.checkNotNull((Object)element3);
        Element errElement = element3;
        SASLModule.SASLError sASLError = SASLModule.SASLError.Companion.valueByElementName(errElement.getName());
        Intrinsics.checkNotNull((Object)((Object)sASLError));
        SASLModule.SASLError saslError = sASLError;
        String errorText = null;
        Element element4 = element2.getFirstChild("text");
        if (element4 != null) {
            Element element5;
            Element $this$processFailure_u24lambda_u244 = element5 = element4;
            boolean bl = false;
            errorText = $this$processFailure_u24lambda_u244.getValue();
        }
        this.engine.evaluateFailure(saslError, errorText);
    }

    private final void processChallenge(Element element2) {
        String v = element2.getValue();
        String r = this.engine.evaluateChallenge(v);
        Element authElement2 = BuilderKt.element("response", (Function1<? super ElementNode, Unit>)((Function1)new Function1<ElementNode, Unit>(r){
            final /* synthetic */ String $r;
            {
                this.$r = $r;
                super(1);
            }

            public final void invoke(@NotNull ElementNode $this$element) {
                Intrinsics.checkNotNullParameter((Object)$this$element, (String)"$this$element");
                $this$element.setXmlns("urn:xmpp:sasl:2");
                if (this.$r != null) {
                    $this$element.unaryPlus(this.$r);
                }
            }
        }));
        this.getContext().getWriter().writeDirectly(authElement2);
    }

    public final boolean isAllowed(@NotNull Element streamFeatures) {
        Intrinsics.checkNotNullParameter((Object)streamFeatures, (String)"streamFeatures");
        return this.getContext().getConfig().getSasl() != null && this.getEnabled() && streamFeatures.getChildrenNS("authentication", XMLNS) != null;
    }

    @Override
    @NotNull
    public <T> ReadWriteProperty<Object, T> propertySimple(@NotNull Scope scope, T initialValue) {
        return XmppModule.DefaultImpls.propertySimple(this, scope, initialValue);
    }

    @Override
    @NotNull
    public <T> ReadWriteProperty<Object, T> property(@NotNull Scope scope, @NotNull Function0<? extends T> initialValueFactory) {
        return XmppModule.DefaultImpls.property(this, scope, initialValueFactory);
    }

    public static final /* synthetic */ DiscoveryModule access$getDiscoveryModule$p(SASL2Module $this) {
        return $this.discoveryModule;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/SASL2Module$Companion;", "Ltigase/halcyon/core/modules/XmppModuleProvider;", "Ltigase/halcyon/core/xmpp/modules/auth/SASL2Module;", "Ltigase/halcyon/core/xmpp/modules/auth/SASL2ModuleConfig;", "()V", "TYPE", "", "getTYPE", "()Ljava/lang/String;", "XMLNS", "configure", "", "module", "cfg", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "doAfterRegistration", "moduleManager", "Ltigase/halcyon/core/modules/ModulesManager;", "instance", "context", "Ltigase/halcyon/core/Context;", "requiredModules", "", "Ltigase/halcyon/core/xmpp/modules/discovery/DiscoveryModule$Companion;", "halcyon-core"})
    public static final class Companion
    implements XmppModuleProvider<SASL2Module, SASL2ModuleConfig> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getTYPE() {
            return TYPE;
        }

        @Override
        public void configure(@NotNull SASL2Module module, @NotNull Function1<? super SASL2ModuleConfig, Unit> cfg) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            cfg.invoke((Object)module);
        }

        @Override
        @NotNull
        public SASL2Module instance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new SASL2Module(context, (DiscoveryModule)context.getModules().getModule(DiscoveryModule.Companion));
        }

        @Override
        @NotNull
        public List<DiscoveryModule.Companion> requiredModules() {
            return CollectionsKt.listOf((Object)DiscoveryModule.Companion);
        }

        @Override
        public void doAfterRegistration(@NotNull SASL2Module module, @NotNull ModulesManager moduleManager) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)moduleManager, (String)"moduleManager");
            module.initialize();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

