/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xml.parser;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.xml.parser.SimpleHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 32\u00020\u0001:\u00043456B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J#\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0018\u00010 j\u0004\u0018\u0001`!0\u001f2\u0006\u0010\"\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J&\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004J;\u0010-\u001a\u0010\u0012\f\u0012\n\u0018\u00010 j\u0004\u0018\u0001`!0\u001f2\u0016\u0010.\u001a\u0012\u0012\f\u0012\n\u0018\u00010 j\u0004\u0018\u0001`!\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010/J/\u00100\u001a\f\u0012\u0006\u0012\u0004\u0018\u000101\u0018\u00010\u001f2\u0016\u0010.\u001a\u0012\u0012\f\u0012\n\u0018\u00010 j\u0004\u0018\u0001`!\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u00102R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\b\u00a8\u00067"}, d2={"Ltigase/halcyon/core/xml/parser/SimpleParser;", "", "()V", "attributesNumberLimit", "", "getAttributesNumberLimit", "()I", "setAttributesNumberLimit", "(I)V", "maxAttribsNumber", "getMaxAttribsNumber", "setMaxAttribsNumber", "maxAttributeNameSize", "getMaxAttributeNameSize", "setMaxAttributeNameSize", "maxAttributeValueSize", "getMaxAttributeValueSize", "setMaxAttributeValueSize", "maxCdataSize", "getMaxCdataSize", "setMaxCdataSize", "maxElementNameSize", "getMaxElementNameSize", "setMaxElementNameSize", "checkIsCharValidInXML", "", "parserState", "Ltigase/halcyon/core/xml/parser/SimpleParser$ParserState;", "chr", "", "initArray", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "size", "(I)[Ljava/lang/StringBuilder;", "isWhite", "parse", "", "handler", "Ltigase/halcyon/core/xml/parser/SimpleHandler;", "data", "", "offset", "len", "resizeArray", "src", "([Ljava/lang/StringBuilder;I)[Ljava/lang/StringBuilder;", "toStringArray", "", "([Ljava/lang/StringBuilder;)[Ljava/lang/String;", "Companion", "EntityType", "ParserState", "State", "halcyon-core"})
public final class SimpleParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int attributesNumberLimit = 50;
    private int maxAttribsNumber = 6;
    private int maxAttributeNameSize = 1024;
    private int maxAttributeValueSize = 10240;
    private int maxCdataSize = 0x100000;
    private int maxElementNameSize = 1024;
    private static final char OPEN_BRACKET = (char)60;
    private static final char CLOSE_BRACKET = (char)62;
    private static final char QUESTION_MARK = (char)63;
    private static final char EXCLAMATION_MARK = (char)33;
    private static final char SLASH = (char)47;
    private static final char SPACE = (char)32;
    private static final char TAB = (char)9;
    private static final char LF = (char)10;
    private static final char CR = (char)13;
    private static final char AMP = (char)38;
    private static final char EQUALS = (char)61;
    private static final char HASH = (char)35;
    private static final char SEMICOLON = (char)59;
    private static final char SINGLE_QUOTE = (char)39;
    private static final char DOUBLE_QUOTE = (char)34;
    @NotNull
    private static final char[] WHITE_CHARS;
    @NotNull
    private static final char[] ERR_NAME_CHARS;
    @NotNull
    private static final boolean[] ALLOWED_CHARS_LOW;

    public final int getAttributesNumberLimit() {
        return this.attributesNumberLimit;
    }

    public final void setAttributesNumberLimit(int n) {
        this.attributesNumberLimit = n;
    }

    public final int getMaxAttribsNumber() {
        return this.maxAttribsNumber;
    }

    public final void setMaxAttribsNumber(int n) {
        this.maxAttribsNumber = n;
    }

    public final int getMaxAttributeNameSize() {
        return this.maxAttributeNameSize;
    }

    public final void setMaxAttributeNameSize(int n) {
        this.maxAttributeNameSize = n;
    }

    public final int getMaxAttributeValueSize() {
        return this.maxAttributeValueSize;
    }

    public final void setMaxAttributeValueSize(int n) {
        this.maxAttributeValueSize = n;
    }

    public final int getMaxCdataSize() {
        return this.maxCdataSize;
    }

    public final void setMaxCdataSize(int n) {
        this.maxCdataSize = n;
    }

    public final int getMaxElementNameSize() {
        return this.maxElementNameSize;
    }

    public final void setMaxElementNameSize(int n) {
        this.maxElementNameSize = n;
    }

    private final boolean checkIsCharValidInXML(ParserState parserState, char chr) {
        ParserState parserState2 = parserState;
        Intrinsics.checkNotNull((Object)parserState2);
        boolean highSurrogate = parserState2.getHighSurrogate$halcyon_core();
        parserState.setHighSurrogate$halcyon_core(false);
        if (chr <= '\ud7ff') {
            return chr >= ' ' ? true : ALLOWED_CHARS_LOW[chr];
        }
        if (chr <= '\ufffd') {
            if (chr >= '\ue000') {
                return true;
            }
            if (Character.isLowSurrogate(chr)) {
                return highSurrogate;
            }
            if (Character.isHighSurrogate(chr)) {
                parserState.setHighSurrogate$halcyon_core(true);
                return true;
            }
        }
        return false;
    }

    private final StringBuilder[] initArray(int size) {
        return new StringBuilder[size];
    }

    private final boolean isWhite(char chr) {
        for (char c : WHITE_CHARS) {
            if (chr != c) continue;
            return true;
        }
        return false;
    }

    public final void parse(@NotNull SimpleHandler handler2, @NotNull char[] data) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.parse(handler2, data, 0, data.length - 1);
    }

    public final void parse(@NotNull SimpleHandler handler2, @NotNull char[] data, int offset, int len) {
        int n;
        int idx;
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ParserState parserState = (ParserState)handler2.restoreParserState();
        if (parserState == null) {
            parserState = new ParserState();
        }
        if ((idx = offset) <= (n = offset + len)) {
            while (true) {
                char chr;
                if (!this.checkIsCharValidInXML(parserState, chr = data[idx])) {
                    parserState.setErrorMessage$halcyon_core("Not allowed character '" + chr + "' in XML stream");
                    parserState.setState$halcyon_core(State.ERROR);
                }
                State state = parserState.getState$halcyon_core();
                switch (state == null ? -1 : WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
                    case 1: {
                        if (chr != OPEN_BRACKET) break;
                        parserState.setState$halcyon_core(State.OPEN_BRACKET);
                        parserState.setSlash_found$halcyon_core(false);
                        break;
                    }
                    case 2: {
                        char c = chr;
                        if (c == QUESTION_MARK ? true : c == EXCLAMATION_MARK) {
                            parserState.setState$halcyon_core(State.OTHER_XML);
                            parserState.setElement_cdata$halcyon_core(new StringBuilder(100));
                            StringBuilder stringBuilder = parserState.getElement_cdata$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilder);
                            stringBuilder.append(chr);
                            break;
                        }
                        if (c == SLASH) {
                            parserState.setState$halcyon_core(State.CLOSE_ELEMENT);
                            parserState.setElement_name$halcyon_core(new StringBuilder(10));
                            parserState.setSlash_found$halcyon_core(true);
                            break;
                        }
                        if (ArraysKt.contains((char[])WHITE_CHARS, (char)chr)) break;
                        if (chr == ERR_NAME_CHARS[0] || chr == ERR_NAME_CHARS[1] || chr == ERR_NAME_CHARS[2]) {
                            parserState.setState$halcyon_core(State.ERROR);
                            parserState.setErrorMessage$halcyon_core("Not allowed character in start element name: " + chr);
                            break;
                        }
                        parserState.setState$halcyon_core(State.ELEMENT_NAME);
                        parserState.setElement_name$halcyon_core(new StringBuilder(10));
                        StringBuilder stringBuilder = parserState.getElement_name$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        stringBuilder.append(chr);
                        break;
                    }
                    case 3: {
                        if (this.isWhite(chr)) {
                            parserState.setState$halcyon_core(State.END_ELEMENT_NAME);
                            break;
                        }
                        if (chr == SLASH) {
                            parserState.setSlash_found$halcyon_core(true);
                            break;
                        }
                        if (chr == CLOSE_BRACKET) {
                            parserState.setState$halcyon_core(State.ELEMENT_CDATA);
                            StringBuilder stringBuilder = parserState.getElement_name$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilder);
                            String string = stringBuilder.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parserState.element_name!!.toString()");
                            handler2.startElement(string, null, null);
                            if (parserState.getSlash_found$halcyon_core()) {
                                StringBuilder stringBuilder2 = parserState.getElement_name$halcyon_core();
                                Intrinsics.checkNotNull((Object)stringBuilder2);
                                String string2 = stringBuilder2.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parserState.element_name!!.toString()");
                                handler2.endElement(string2);
                            }
                            parserState.setElement_name$halcyon_core(null);
                            break;
                        }
                        if (chr == ERR_NAME_CHARS[0] || chr == ERR_NAME_CHARS[1] || chr == ERR_NAME_CHARS[2]) {
                            parserState.setState$halcyon_core(State.ERROR);
                            StringBuilder stringBuilder = parserState.getElement_name$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilder);
                            parserState.setErrorMessage$halcyon_core("Not allowed character in start element name: " + chr + "\nExisting characters in start element name: " + stringBuilder);
                            break;
                        }
                        StringBuilder stringBuilder = parserState.getElement_name$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        stringBuilder.append(chr);
                        StringBuilder stringBuilder3 = parserState.getElement_name$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder3);
                        if (stringBuilder3.length() <= this.maxElementNameSize) break;
                        parserState.setState$halcyon_core(State.ERROR);
                        StringBuilder stringBuilder4 = parserState.getElement_name$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder4);
                        parserState.setErrorMessage$halcyon_core("Max element name size exceeded: " + this.maxElementNameSize + "\nreceived: " + stringBuilder4);
                        break;
                    }
                    case 4: {
                        if (this.isWhite(chr)) break;
                        if (chr == SLASH) {
                            parserState.setState$halcyon_core(State.ERROR);
                            StringBuilder stringBuilder = parserState.getElement_name$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilder);
                            parserState.setErrorMessage$halcyon_core("Not allowed character in close element name: " + chr + "\nExisting characters in close element name: " + stringBuilder);
                            break;
                        }
                        if (chr == CLOSE_BRACKET) {
                            parserState.setState$halcyon_core(State.ELEMENT_CDATA);
                            StringBuilder stringBuilder = parserState.getElement_name$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilder);
                            String string = stringBuilder.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parserState.element_name!!.toString()");
                            if (!handler2.endElement(string)) {
                                parserState.setState$halcyon_core(State.ERROR);
                                StringBuilder stringBuilder5 = parserState.getElement_name$halcyon_core();
                                Intrinsics.checkNotNull((Object)stringBuilder5);
                                parserState.setErrorMessage$halcyon_core("Malformed XML: element close found without open for this element: " + stringBuilder5);
                                break;
                            }
                            parserState.setElement_name$halcyon_core(null);
                            break;
                        }
                        if (chr == ERR_NAME_CHARS[0] || chr == ERR_NAME_CHARS[1] || chr == ERR_NAME_CHARS[2]) {
                            parserState.setState$halcyon_core(State.ERROR);
                            StringBuilder stringBuilder = parserState.getElement_name$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilder);
                            parserState.setErrorMessage$halcyon_core("Not allowed character in close element name: " + chr + "\nExisting characters in close element name: " + stringBuilder);
                            break;
                        }
                        StringBuilder stringBuilder = parserState.getElement_name$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        stringBuilder.append(chr);
                        StringBuilder stringBuilder6 = parserState.getElement_name$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder6);
                        if (stringBuilder6.length() <= this.maxElementNameSize) break;
                        parserState.setState$halcyon_core(State.ERROR);
                        StringBuilder stringBuilder7 = parserState.getElement_name$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder7);
                        parserState.setErrorMessage$halcyon_core("Max element name size exceeded: " + this.maxElementNameSize + "\nreceived: " + stringBuilder7);
                        break;
                    }
                    case 5: {
                        char newSize2;
                        if (chr == SLASH) {
                            parserState.setSlash_found$halcyon_core(true);
                            break;
                        }
                        if (chr == CLOSE_BRACKET) {
                            parserState.setState$halcyon_core(State.ELEMENT_CDATA);
                            StringBuilder stringBuilder = parserState.getElement_name$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilder);
                            String string = stringBuilder.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parserState.element_name!!.toString()");
                            handler2.startElement(string, this.toStringArray(parserState.getAttrib_names$halcyon_core()), this.toStringArray(parserState.getAttrib_values$halcyon_core()));
                            parserState.setAttrib_names$halcyon_core(null);
                            parserState.setAttrib_values$halcyon_core(null);
                            parserState.setCurrent_attr$halcyon_core(-1);
                            if (parserState.getSlash_found$halcyon_core()) {
                                StringBuilder stringBuilder8 = parserState.getElement_name$halcyon_core();
                                Intrinsics.checkNotNull((Object)stringBuilder8);
                                String string3 = stringBuilder8.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parserState.element_name!!.toString()");
                                handler2.endElement(string3);
                            }
                            parserState.setElement_name$halcyon_core(null);
                            break;
                        }
                        if (this.isWhite(chr)) break;
                        parserState.setState$halcyon_core(State.ATTRIB_NAME);
                        if (parserState.getAttrib_names$halcyon_core() == null) {
                            parserState.setAttrib_names$halcyon_core(this.initArray(this.maxAttribsNumber));
                            parserState.setAttrib_values$halcyon_core(this.initArray(this.maxAttribsNumber));
                        } else {
                            int n2 = parserState.getCurrent_attr$halcyon_core();
                            StringBuilder[] stringBuilderArray = parserState.getAttrib_names$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilderArray);
                            if (n2 == stringBuilderArray.length - 1) {
                                StringBuilder[] stringBuilderArray2 = parserState.getAttrib_names$halcyon_core();
                                Intrinsics.checkNotNull((Object)stringBuilderArray2);
                                if (stringBuilderArray2.length >= this.attributesNumberLimit) {
                                    parserState.setState$halcyon_core(State.ERROR);
                                    StringBuilder stringBuilder = parserState.getElement_name$halcyon_core();
                                    Intrinsics.checkNotNull((Object)stringBuilder);
                                    parserState.setErrorMessage$halcyon_core("Attributes nuber limit exceeded: " + this.attributesNumberLimit + "\nreceived: " + stringBuilder);
                                    break;
                                }
                                StringBuilder[] stringBuilderArray3 = parserState.getAttrib_names$halcyon_core();
                                Intrinsics.checkNotNull((Object)stringBuilderArray3);
                                newSize2 = stringBuilderArray3.length + this.maxAttribsNumber;
                                parserState.setAttrib_names$halcyon_core(this.resizeArray(parserState.getAttrib_names$halcyon_core(), newSize2));
                                parserState.setAttrib_values$halcyon_core(this.resizeArray(parserState.getAttrib_values$halcyon_core(), newSize2));
                            }
                        }
                        StringBuilder[] stringBuilderArray = parserState.getAttrib_names$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray);
                        ParserState newSize2 = parserState;
                        newSize2.setCurrent_attr$halcyon_core(newSize2.getCurrent_attr$halcyon_core() + 1);
                        stringBuilderArray[newSize2.getCurrent_attr$halcyon_core()] = new StringBuilder(8);
                        StringBuilder[] stringBuilderArray4 = parserState.getAttrib_names$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray4);
                        StringBuilder stringBuilder = stringBuilderArray4[parserState.getCurrent_attr$halcyon_core()];
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        stringBuilder.append(chr);
                        break;
                    }
                    case 6: {
                        if (this.isWhite(chr) || chr == EQUALS) {
                            parserState.setState$halcyon_core(State.END_OF_ATTR_NAME);
                            break;
                        }
                        if (chr == ERR_NAME_CHARS[0] || chr == ERR_NAME_CHARS[1] || chr == ERR_NAME_CHARS[2]) {
                            parserState.setState$halcyon_core(State.ERROR);
                            StringBuilder[] stringBuilderArray = parserState.getAttrib_names$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilderArray);
                            parserState.setErrorMessage$halcyon_core("Not allowed character in element attribute name: " + chr + "\nExisting characters in element attribute name: " + stringBuilderArray[parserState.getCurrent_attr$halcyon_core()]);
                            break;
                        }
                        StringBuilder[] stringBuilderArray = parserState.getAttrib_names$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray);
                        StringBuilder stringBuilder = stringBuilderArray[parserState.getCurrent_attr$halcyon_core()];
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        stringBuilder.append(chr);
                        StringBuilder[] stringBuilderArray5 = parserState.getAttrib_names$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray5);
                        StringBuilder stringBuilder9 = stringBuilderArray5[parserState.getCurrent_attr$halcyon_core()];
                        Intrinsics.checkNotNull((Object)stringBuilder9);
                        if (stringBuilder9.length() <= this.maxAttributeNameSize) break;
                        parserState.setState$halcyon_core(State.ERROR);
                        StringBuilder[] stringBuilderArray6 = parserState.getAttrib_names$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray6);
                        parserState.setErrorMessage$halcyon_core("Max attribute name size exceeded: " + this.maxAttributeNameSize + "\nreceived: " + stringBuilderArray6[parserState.getCurrent_attr$halcyon_core()]);
                        break;
                    }
                    case 7: {
                        if (chr == SINGLE_QUOTE) {
                            parserState.setState$halcyon_core(State.ATTRIB_VALUE_S);
                            StringBuilder[] stringBuilderArray = parserState.getAttrib_values$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilderArray);
                            stringBuilderArray[parserState.getCurrent_attr$halcyon_core()] = new StringBuilder(64);
                        }
                        if (chr != DOUBLE_QUOTE) break;
                        parserState.setState$halcyon_core(State.ATTRIB_VALUE_D);
                        StringBuilder[] stringBuilderArray = parserState.getAttrib_values$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray);
                        stringBuilderArray[parserState.getCurrent_attr$halcyon_core()] = new StringBuilder(64);
                        break;
                    }
                    case 8: {
                        if (chr == SINGLE_QUOTE) {
                            parserState.setState$halcyon_core(State.END_ELEMENT_NAME);
                            break;
                        }
                        StringBuilder[] stringBuilderArray = parserState.getAttrib_values$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray);
                        StringBuilder stringBuilder = stringBuilderArray[parserState.getCurrent_attr$halcyon_core()];
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        stringBuilder.append(chr);
                        char newSize2 = chr;
                        if (newSize2 == '&') {
                            parserState.setParentState$halcyon_core(parserState.getState$halcyon_core());
                            parserState.setState$halcyon_core(State.ENTITY);
                            parserState.setEntityType$halcyon_core(EntityType.UNKNOWN);
                        } else if (newSize2 == '<') {
                            parserState.setState$halcyon_core(State.ERROR);
                            StringBuilder[] stringBuilderArray7 = parserState.getAttrib_values$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilderArray7);
                            parserState.setErrorMessage$halcyon_core("Not allowed character in element attribute value: " + chr + "\nExisting characters in element attribute value: " + stringBuilderArray7[parserState.getCurrent_attr$halcyon_core()]);
                        }
                        StringBuilder[] stringBuilderArray8 = parserState.getAttrib_values$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray8);
                        StringBuilder stringBuilder10 = stringBuilderArray8[parserState.getCurrent_attr$halcyon_core()];
                        Intrinsics.checkNotNull((Object)stringBuilder10);
                        if (stringBuilder10.length() <= this.maxAttributeValueSize) break;
                        parserState.setState$halcyon_core(State.ERROR);
                        StringBuilder[] stringBuilderArray9 = parserState.getAttrib_values$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray9);
                        parserState.setErrorMessage$halcyon_core("Max attribute value size exceeded: " + this.maxAttributeValueSize + "\nreceived: " + stringBuilderArray9[parserState.getCurrent_attr$halcyon_core()]);
                        break;
                    }
                    case 9: {
                        if (chr == DOUBLE_QUOTE) {
                            parserState.setState$halcyon_core(State.END_ELEMENT_NAME);
                            break;
                        }
                        StringBuilder[] stringBuilderArray = parserState.getAttrib_values$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray);
                        StringBuilder stringBuilder = stringBuilderArray[parserState.getCurrent_attr$halcyon_core()];
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        stringBuilder.append(chr);
                        char newSize2 = chr;
                        if (newSize2 == '&') {
                            parserState.setParentState$halcyon_core(parserState.getState$halcyon_core());
                            parserState.setState$halcyon_core(State.ENTITY);
                            parserState.setEntityType$halcyon_core(EntityType.UNKNOWN);
                        } else if (newSize2 == '<') {
                            parserState.setState$halcyon_core(State.ERROR);
                            StringBuilder[] stringBuilderArray10 = parserState.getAttrib_values$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilderArray10);
                            parserState.setErrorMessage$halcyon_core("Not allowed character in element attribute value: " + chr + "\nExisting characters in element attribute value: " + stringBuilderArray10[parserState.getCurrent_attr$halcyon_core()]);
                        }
                        StringBuilder[] stringBuilderArray11 = parserState.getAttrib_values$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray11);
                        StringBuilder stringBuilder11 = stringBuilderArray11[parserState.getCurrent_attr$halcyon_core()];
                        Intrinsics.checkNotNull((Object)stringBuilder11);
                        if (stringBuilder11.length() <= this.maxAttributeValueSize) break;
                        parserState.setState$halcyon_core(State.ERROR);
                        StringBuilder[] stringBuilderArray12 = parserState.getAttrib_values$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilderArray12);
                        parserState.setErrorMessage$halcyon_core("Max attribute value size exceeded: " + this.maxAttributeValueSize + "\nreceived: " + stringBuilderArray12[parserState.getCurrent_attr$halcyon_core()]);
                        break;
                    }
                    case 10: {
                        if (chr == OPEN_BRACKET) {
                            parserState.setState$halcyon_core(State.OPEN_BRACKET);
                            parserState.setSlash_found$halcyon_core(false);
                            if (parserState.getElement_cdata$halcyon_core() == null) break;
                            StringBuilder stringBuilder = parserState.getElement_cdata$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilder);
                            String string = stringBuilder.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parserState.element_cdata!!.toString()");
                            handler2.elementCData(string);
                            parserState.setElement_cdata$halcyon_core(null);
                            break;
                        }
                        if (parserState.getElement_cdata$halcyon_core() == null) {
                            parserState.setElement_cdata$halcyon_core(new StringBuilder(100));
                        }
                        StringBuilder stringBuilder = parserState.getElement_cdata$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        stringBuilder.append(chr);
                        if (chr == '&') {
                            parserState.setParentState$halcyon_core(parserState.getState$halcyon_core());
                            parserState.setState$halcyon_core(State.ENTITY);
                            parserState.setEntityType$halcyon_core(EntityType.UNKNOWN);
                        }
                        StringBuilder stringBuilder12 = parserState.getElement_cdata$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder12);
                        if (stringBuilder12.length() <= this.maxCdataSize) break;
                        parserState.setState$halcyon_core(State.ERROR);
                        StringBuilder stringBuilder13 = parserState.getElement_cdata$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder13);
                        parserState.setErrorMessage$halcyon_core("Max cdata size exceeded: " + this.maxCdataSize + "\nreceived: " + stringBuilder13);
                        break;
                    }
                    case 11: {
                        boolean alpha = Intrinsics.compare((int)chr, (int)97) >= 0 && Intrinsics.compare((int)chr, (int)122) <= 0 || Intrinsics.compare((int)chr, (int)65) >= 0 && Intrinsics.compare((int)chr, (int)90) <= 0;
                        boolean numeric = !alpha && Intrinsics.compare((int)chr, (int)48) >= 0 && Intrinsics.compare((int)chr, (int)57) <= 0;
                        boolean valid = true;
                        switch (WhenMappings.$EnumSwitchMapping$0[parserState.getEntityType$halcyon_core().ordinal()]) {
                            case 1: {
                                if (alpha) {
                                    parserState.setEntityType$halcyon_core(EntityType.NAMED);
                                    break;
                                }
                                if (chr == HASH) {
                                    parserState.setEntityType$halcyon_core(EntityType.CODEPOINT);
                                    break;
                                }
                                valid = false;
                                break;
                            }
                            case 2: {
                                if (alpha || numeric) break;
                                if (chr != SEMICOLON) {
                                    valid = false;
                                    break;
                                }
                                parserState.setState$halcyon_core(parserState.getParentState$halcyon_core());
                                break;
                            }
                            case 3: {
                                if (chr == 'x') {
                                    parserState.setEntityType$halcyon_core(EntityType.CODEPOINT_HEX);
                                }
                                if (numeric) {
                                    parserState.setEntityType$halcyon_core(EntityType.CODEPOINT_DEC);
                                    break;
                                }
                                valid = false;
                                break;
                            }
                            case 4: {
                                if (numeric) break;
                                if (chr != SEMICOLON) {
                                    valid = false;
                                    break;
                                }
                                parserState.setState$halcyon_core(parserState.getParentState$halcyon_core());
                                break;
                            }
                            case 5: {
                                if (Intrinsics.compare((int)chr, (int)97) >= 0 && Intrinsics.compare((int)chr, (int)102) <= 0 || Intrinsics.compare((int)chr, (int)65) >= 0 || Intrinsics.compare((int)chr, (int)70) <= 0 || numeric) break;
                                if (chr != SEMICOLON) {
                                    valid = false;
                                    break;
                                }
                                parserState.setState$halcyon_core(parserState.getParentState$halcyon_core());
                            }
                        }
                        if (valid) {
                            if (parserState.getParentState$halcyon_core() == State.ATTRIB_VALUE_D || parserState.getParentState$halcyon_core() == State.ATTRIB_VALUE_S) {
                                StringBuilder[] stringBuilderArray = parserState.getAttrib_values$halcyon_core();
                                Intrinsics.checkNotNull((Object)stringBuilderArray);
                                StringBuilder stringBuilder = stringBuilderArray[parserState.getCurrent_attr$halcyon_core()];
                                Intrinsics.checkNotNull((Object)stringBuilder);
                                stringBuilder.append(chr);
                                break;
                            }
                            if (parserState.getParentState$halcyon_core() != State.ELEMENT_CDATA) break;
                            StringBuilder stringBuilder = parserState.getElement_cdata$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilder);
                            stringBuilder.append(chr);
                            break;
                        }
                        parserState.setState$halcyon_core(State.ERROR);
                        parserState.setErrorMessage$halcyon_core("Invalid XML entity");
                        break;
                    }
                    case 12: {
                        if (chr == CLOSE_BRACKET) {
                            parserState.setState$halcyon_core(State.START);
                            StringBuilder stringBuilder = parserState.getElement_cdata$halcyon_core();
                            Intrinsics.checkNotNull((Object)stringBuilder);
                            String string = stringBuilder.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parserState.element_cdata!!.toString()");
                            handler2.otherXML(string);
                            parserState.setElement_cdata$halcyon_core(null);
                            break;
                        }
                        if (parserState.getElement_cdata$halcyon_core() == null) {
                            parserState.setElement_cdata$halcyon_core(new StringBuilder(100));
                        }
                        StringBuilder stringBuilder = parserState.getElement_cdata$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder);
                        stringBuilder.append(chr);
                        StringBuilder stringBuilder14 = parserState.getElement_cdata$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder14);
                        if (stringBuilder14.length() <= this.maxCdataSize) break;
                        parserState.setState$halcyon_core(State.ERROR);
                        StringBuilder stringBuilder15 = parserState.getElement_cdata$halcyon_core();
                        Intrinsics.checkNotNull((Object)stringBuilder15);
                        parserState.setErrorMessage$halcyon_core("Max cdata size exceeded: " + this.maxCdataSize + "\nreceived: " + stringBuilder15);
                        break;
                    }
                    case 13: {
                        String string = parserState.getErrorMessage$halcyon_core();
                        Intrinsics.checkNotNull((Object)string);
                        handler2.error(string);
                        return;
                    }
                    default: {
                        throw new RuntimeException("Unknown SimpleParser state: " + parserState.getState$halcyon_core());
                    }
                }
                if (idx == n) break;
                ++idx;
            }
        }
        handler2.saveParserState(parserState);
    }

    private final String[] toStringArray(StringBuilder[] src) {
        if (src == null) {
            return null;
        }
        String[] res = new String[src.length];
        int n = src.length;
        for (int i = 0; i < n; ++i) {
            res[i] = src[i] == null ? null : String.valueOf(src[i]);
        }
        return res;
    }

    private final StringBuilder[] resizeArray(StringBuilder[] src, int size) {
        Intrinsics.checkNotNull((Object)src);
        StringBuilder[] stringBuilderArray = Arrays.copyOf(src, size);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilderArray, (String)"copyOf(this, newSize)");
        return stringBuilderArray;
    }

    static {
        char[] cArray = new char[]{SPACE, LF, CR, TAB};
        WHITE_CHARS = ArraysKt.sortedArray((char[])cArray);
        cArray = new char[]{OPEN_BRACKET, QUESTION_MARK, AMP};
        ERR_NAME_CHARS = ArraysKt.sortedArray((char[])cArray);
        ALLOWED_CHARS_LOW = new boolean[32];
        SimpleParser.ALLOWED_CHARS_LOW[9] = true;
        SimpleParser.ALLOWED_CHARS_LOW[10] = true;
        SimpleParser.ALLOWED_CHARS_LOW[13] = true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltigase/halcyon/core/xml/parser/SimpleParser$Companion;", "", "()V", "ALLOWED_CHARS_LOW", "", "AMP", "", "CLOSE_BRACKET", "CR", "DOUBLE_QUOTE", "EQUALS", "ERR_NAME_CHARS", "", "EXCLAMATION_MARK", "HASH", "LF", "OPEN_BRACKET", "QUESTION_MARK", "SEMICOLON", "SINGLE_QUOTE", "SLASH", "SPACE", "TAB", "WHITE_CHARS", "halcyon-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ltigase/halcyon/core/xml/parser/SimpleParser$EntityType;", "", "(Ljava/lang/String;I)V", "UNKNOWN", "NAMED", "CODEPOINT", "CODEPOINT_DEC", "CODEPOINT_HEX", "halcyon-core"})
    public static final class EntityType
    extends Enum<EntityType> {
        public static final /* enum */ EntityType UNKNOWN = new EntityType();
        public static final /* enum */ EntityType NAMED = new EntityType();
        public static final /* enum */ EntityType CODEPOINT = new EntityType();
        public static final /* enum */ EntityType CODEPOINT_DEC = new EntityType();
        public static final /* enum */ EntityType CODEPOINT_HEX = new EntityType();
        private static final /* synthetic */ EntityType[] $VALUES;

        public static EntityType[] values() {
            return (EntityType[])$VALUES.clone();
        }

        public static EntityType valueOf(String value) {
            return Enum.valueOf(EntityType.class, value);
        }

        static {
            $VALUES = entityTypeArray = new EntityType[]{EntityType.UNKNOWN, EntityType.NAMED, EntityType.CODEPOINT, EntityType.CODEPOINT_DEC, EntityType.CODEPOINT_HEX};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R,\u0010\u0003\u001a\u0012\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR,\u0010\f\u001a\u0012\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020*X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010,\"\u0004\b7\u0010.R\u001c\u00108\u001a\u0004\u0018\u000100X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00102\"\u0004\b:\u00104\u00a8\u0006;"}, d2={"Ltigase/halcyon/core/xml/parser/SimpleParser$ParserState;", "", "()V", "attrib_names", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getAttrib_names$halcyon_core", "()[Ljava/lang/StringBuilder;", "setAttrib_names$halcyon_core", "([Ljava/lang/StringBuilder;)V", "[Ljava/lang/StringBuilder;", "attrib_values", "getAttrib_values$halcyon_core", "setAttrib_values$halcyon_core", "current_attr", "", "getCurrent_attr$halcyon_core", "()I", "setCurrent_attr$halcyon_core", "(I)V", "element_cdata", "getElement_cdata$halcyon_core", "()Ljava/lang/StringBuilder;", "setElement_cdata$halcyon_core", "(Ljava/lang/StringBuilder;)V", "element_name", "getElement_name$halcyon_core", "setElement_name$halcyon_core", "entityType", "Ltigase/halcyon/core/xml/parser/SimpleParser$EntityType;", "getEntityType$halcyon_core", "()Ltigase/halcyon/core/xml/parser/SimpleParser$EntityType;", "setEntityType$halcyon_core", "(Ltigase/halcyon/core/xml/parser/SimpleParser$EntityType;)V", "errorMessage", "", "getErrorMessage$halcyon_core", "()Ljava/lang/String;", "setErrorMessage$halcyon_core", "(Ljava/lang/String;)V", "highSurrogate", "", "getHighSurrogate$halcyon_core", "()Z", "setHighSurrogate$halcyon_core", "(Z)V", "parentState", "Ltigase/halcyon/core/xml/parser/SimpleParser$State;", "getParentState$halcyon_core", "()Ltigase/halcyon/core/xml/parser/SimpleParser$State;", "setParentState$halcyon_core", "(Ltigase/halcyon/core/xml/parser/SimpleParser$State;)V", "slash_found", "getSlash_found$halcyon_core", "setSlash_found$halcyon_core", "state", "getState$halcyon_core", "setState$halcyon_core", "halcyon-core"})
    public static final class ParserState {
        @Nullable
        private StringBuilder[] attrib_names;
        @Nullable
        private StringBuilder[] attrib_values;
        private int current_attr = -1;
        @Nullable
        private StringBuilder element_cdata;
        @Nullable
        private StringBuilder element_name;
        @NotNull
        private EntityType entityType = EntityType.UNKNOWN;
        @Nullable
        private String errorMessage;
        private boolean highSurrogate;
        @Nullable
        private State parentState;
        private boolean slash_found;
        @Nullable
        private State state = State.START;

        @Nullable
        public final StringBuilder[] getAttrib_names$halcyon_core() {
            return this.attrib_names;
        }

        public final void setAttrib_names$halcyon_core(@Nullable StringBuilder[] stringBuilderArray) {
            this.attrib_names = stringBuilderArray;
        }

        @Nullable
        public final StringBuilder[] getAttrib_values$halcyon_core() {
            return this.attrib_values;
        }

        public final void setAttrib_values$halcyon_core(@Nullable StringBuilder[] stringBuilderArray) {
            this.attrib_values = stringBuilderArray;
        }

        public final int getCurrent_attr$halcyon_core() {
            return this.current_attr;
        }

        public final void setCurrent_attr$halcyon_core(int n) {
            this.current_attr = n;
        }

        @Nullable
        public final StringBuilder getElement_cdata$halcyon_core() {
            return this.element_cdata;
        }

        public final void setElement_cdata$halcyon_core(@Nullable StringBuilder stringBuilder) {
            this.element_cdata = stringBuilder;
        }

        @Nullable
        public final StringBuilder getElement_name$halcyon_core() {
            return this.element_name;
        }

        public final void setElement_name$halcyon_core(@Nullable StringBuilder stringBuilder) {
            this.element_name = stringBuilder;
        }

        @NotNull
        public final EntityType getEntityType$halcyon_core() {
            return this.entityType;
        }

        public final void setEntityType$halcyon_core(@NotNull EntityType entityType) {
            Intrinsics.checkNotNullParameter((Object)((Object)entityType), (String)"<set-?>");
            this.entityType = entityType;
        }

        @Nullable
        public final String getErrorMessage$halcyon_core() {
            return this.errorMessage;
        }

        public final void setErrorMessage$halcyon_core(@Nullable String string) {
            this.errorMessage = string;
        }

        public final boolean getHighSurrogate$halcyon_core() {
            return this.highSurrogate;
        }

        public final void setHighSurrogate$halcyon_core(boolean bl) {
            this.highSurrogate = bl;
        }

        @Nullable
        public final State getParentState$halcyon_core() {
            return this.parentState;
        }

        public final void setParentState$halcyon_core(@Nullable State state) {
            this.parentState = state;
        }

        public final boolean getSlash_found$halcyon_core() {
            return this.slash_found;
        }

        public final void setSlash_found$halcyon_core(boolean bl) {
            this.slash_found = bl;
        }

        @Nullable
        public final State getState$halcyon_core() {
            return this.state;
        }

        public final void setState$halcyon_core(@Nullable State state) {
            this.state = state;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000f\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Ltigase/halcyon/core/xml/parser/SimpleParser$State;", "", "(Ljava/lang/String;I)V", "START", "OPEN_BRACKET", "ELEMENT_NAME", "END_ELEMENT_NAME", "ATTRIB_NAME", "END_OF_ATTR_NAME", "ATTRIB_VALUE_S", "ATTRIB_VALUE_D", "ELEMENT_CDATA", "OTHER_XML", "ERROR", "CLOSE_ELEMENT", "ENTITY", "halcyon-core"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State START = new State();
        public static final /* enum */ State OPEN_BRACKET = new State();
        public static final /* enum */ State ELEMENT_NAME = new State();
        public static final /* enum */ State END_ELEMENT_NAME = new State();
        public static final /* enum */ State ATTRIB_NAME = new State();
        public static final /* enum */ State END_OF_ATTR_NAME = new State();
        public static final /* enum */ State ATTRIB_VALUE_S = new State();
        public static final /* enum */ State ATTRIB_VALUE_D = new State();
        public static final /* enum */ State ELEMENT_CDATA = new State();
        public static final /* enum */ State OTHER_XML = new State();
        public static final /* enum */ State ERROR = new State();
        public static final /* enum */ State CLOSE_ELEMENT = new State();
        public static final /* enum */ State ENTITY = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.START, State.OPEN_BRACKET, State.ELEMENT_NAME, State.END_ELEMENT_NAME, State.ATTRIB_NAME, State.END_OF_ATTR_NAME, State.ATTRIB_VALUE_S, State.ATTRIB_VALUE_D, State.ELEMENT_CDATA, State.OTHER_XML, State.ERROR, State.CLOSE_ELEMENT, State.ENTITY};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[EntityType.values().length];
            try {
                nArray[EntityType.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.NAMED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.CODEPOINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.CODEPOINT_DEC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityType.CODEPOINT_HEX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[State.values().length];
            try {
                nArray[State.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.OPEN_BRACKET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.ELEMENT_NAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.CLOSE_ELEMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.END_ELEMENT_NAME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.ATTRIB_NAME.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.END_OF_ATTR_NAME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.ATTRIB_VALUE_S.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.ATTRIB_VALUE_D.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.ELEMENT_CDATA.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.ENTITY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.OTHER_XML.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.ERROR.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

