/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.minidns.dnssec.DnssecValidationFailedException;
import tigase.halcyon.core.Halcyon;
import tigase.halcyon.core.configuration.ConfigurationKt;
import tigase.halcyon.core.configuration.ConnectionConfig;
import tigase.halcyon.core.connector.AbstractConnector;
import tigase.halcyon.core.connector.ParseErrorEvent;
import tigase.halcyon.core.connector.ReceivedXMLElementEvent;
import tigase.halcyon.core.connector.SessionController;
import tigase.halcyon.core.connector.SrvRecord;
import tigase.halcyon.core.connector.State;
import tigase.halcyon.core.connector.StreamStartedEvent;
import tigase.halcyon.core.connector.StreamTerminatedEvent;
import tigase.halcyon.core.connector.socket.HostNotFound;
import tigase.halcyon.core.connector.socket.SocketConnectionErrorEvent;
import tigase.halcyon.core.connector.socket.SocketConnector;
import tigase.halcyon.core.connector.socket.SocketConnectorConfig;
import tigase.halcyon.core.connector.socket.SocketSessionController;
import tigase.halcyon.core.connector.socket.SocketWorker;
import tigase.halcyon.core.excutor.TickExecutor;
import tigase.halcyon.core.logger.Level;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xml.BuilderKt;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xml.ElementNode;
import tigase.halcyon.core.xml.parser.StreamParser;
import tigase.halcyon.core.xmpp.BareJID;
import tigase.halcyon.core.xmpp.ErrorCondition;
import tigase.halcyon.core.xmpp.XMPPException;
import tigase.halcyon.core.xmpp.modules.sm.StreamManagementModule;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009d\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005*\u0001\n\u0018\u0000 ;2\u00020\u0001:\u0001;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\u00020\u00192\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00190\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0019H\u0002J\u0014\u0010&\u001a\u00020\u00192\n\u0010!\u001a\u00060'j\u0002`(H\u0002J\b\u0010)\u001a\u00020\u0019H\u0002J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,H\u0002J2\u0010.\u001a\u00020\u00192(\u0010\u001d\u001a$\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020200j\u0002`30/\u0012\u0004\u0012\u00020\u00190\u001eH\u0002J\u0006\u00104\u001a\u00020\u0019J\u0010\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\u0019H\u0016J\u0006\u00109\u001a\u00020\u0019J\b\u0010:\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Ltigase/halcyon/core/connector/socket/SocketConnector;", "Ltigase/halcyon/core/connector/AbstractConnector;", "halcyon", "Ltigase/halcyon/core/Halcyon;", "(Ltigase/halcyon/core/Halcyon;)V", "config", "Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;", "log", "Ltigase/halcyon/core/logger/Logger;", "parser", "tigase/halcyon/core/connector/socket/SocketConnector$parser$1", "Ltigase/halcyon/core/connector/socket/SocketConnector$parser$1;", "<set-?>", "", "secured", "getSecured", "()Z", "socket", "Ljava/net/Socket;", "whiteSpaceEnabled", "whitespacePingExecutor", "Ltigase/halcyon/core/excutor/TickExecutor;", "worker", "Ltigase/halcyon/core/connector/socket/SocketWorker;", "closeStream", "", "createSessionController", "Ltigase/halcyon/core/connector/SessionController;", "createSocket", "completionHandler", "Lkotlin/Function1;", "createSocketConnectionErrorEvent", "Ltigase/halcyon/core/connector/socket/SocketConnectionErrorEvent;", "cause", "", "getSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "onTick", "onWorkerException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "proceedTLS", "processReceivedElement", "element", "Ltigase/halcyon/core/xml/Element;", "processTLSStanza", "resolveTarget", "", "Lkotlin/Pair;", "", "", "Ltigase/halcyon/core/connector/socket/HostPort;", "restartStream", "send", "data", "", "start", "startTLS", "stop", "Companion", "halcyon-core"})
public final class SocketConnector
extends AbstractConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean secured;
    @NotNull
    private final Logger log;
    private Socket socket;
    private SocketWorker worker;
    @NotNull
    private final TickExecutor whitespacePingExecutor;
    private boolean whiteSpaceEnabled;
    @NotNull
    private SocketConnectorConfig config;
    @NotNull
    private final parser.1 parser;
    @NotNull
    public static final String SERVER_HOST = "tigase.halcyon.core.connector.socket.SocketConnector#serverHost";
    @NotNull
    public static final String SERVER_PORT = "tigase.halcyon.core.connector.socket.SocketConnector#serverPort";
    @NotNull
    public static final String SEE_OTHER_HOST_KEY = "tigase.halcyon.core.connector.socket.SocketConnector#seeOtherHost";
    @NotNull
    public static final String XMLNS_START_TLS = "urn:ietf:params:xml:ns:xmpp-tls";

    public SocketConnector(@NotNull Halcyon halcyon) {
        Intrinsics.checkNotNullParameter((Object)halcyon, (String)"halcyon");
        super(halcyon);
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.connector.socket.SocketConnector", false, 2, null);
        this.whitespacePingExecutor = new TickExecutor(halcyon.getEventBus(), DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), (Function0)new Function0<Unit>(this){
            final /* synthetic */ SocketConnector this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                SocketConnector.access$onTick(this.this$0);
            }
        }, null);
        this.whiteSpaceEnabled = true;
        ConnectionConfig connectionConfig = halcyon.getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        this.config = (SocketConnectorConfig)connectionConfig;
        this.parser = new StreamParser(this, halcyon){
            final /* synthetic */ SocketConnector this$0;
            final /* synthetic */ Halcyon $halcyon;
            {
                this.this$0 = $receiver;
                this.$halcyon = $halcyon;
            }

            private final void logReceivedStanza(Element element2) {
                if (SocketConnector.access$getLog$p(this.this$0).isLoggable(Level.FINEST)) {
                    SocketConnector.access$getLog$p(this.this$0).finest("Received element " + Element.DefaultImpls.getAsString$default(element2, 0, false, 3, null));
                } else if (SocketConnector.access$getLog$p(this.this$0).isLoggable(Level.FINER)) {
                    SocketConnector.access$getLog$p(this.this$0).finer("Received element " + element2.getAsString(3, false));
                } else if (SocketConnector.access$getLog$p(this.this$0).isLoggable(Level.FINE)) {
                    SocketConnector.access$getLog$p(this.this$0).fine("Received element " + element2.getAsString(2, false));
                }
            }

            public void onNextElement(@NotNull Element element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                this.logReceivedStanza(element2);
                SocketConnector.access$processReceivedElement(this.this$0, element2);
            }

            public void onStreamClosed() {
                Logger.DefaultImpls.finest$default(SocketConnector.access$getLog$p(this.this$0), null, parser.onStreamClosed.1.INSTANCE, 1, null);
                this.$halcyon.getEventBus().fire(new StreamTerminatedEvent());
            }

            public void onStreamStarted(@NotNull Map<String, String> attrs) {
                Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
                Logger.DefaultImpls.finest$default(SocketConnector.access$getLog$p(this.this$0), null, (Function0)new Function0<Object>(attrs){
                    final /* synthetic */ Map<String, String> $attrs;
                    {
                        this.$attrs = $attrs;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Stream started: " + this.$attrs;
                    }
                }, 1, null);
                this.$halcyon.getEventBus().fire(new StreamStartedEvent(attrs));
            }

            public void onParseError(@NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                Logger.DefaultImpls.finest$default(SocketConnector.access$getLog$p(this.this$0), null, (Function0)new Function0<Object>(errorMessage){
                    final /* synthetic */ String $errorMessage;
                    {
                        this.$errorMessage = $errorMessage;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Parse error: " + this.$errorMessage;
                    }
                }, 1, null);
                this.$halcyon.getEventBus().fire(new ParseErrorEvent(errorMessage));
            }
        };
    }

    public final boolean getSecured() {
        return this.secured;
    }

    private final void processReceivedElement(Element element2) {
        if (Intrinsics.areEqual((Object)element2.getXmlns(), (Object)XMLNS_START_TLS)) {
            this.processTLSStanza(element2);
        } else {
            this.getHalcyon().getEventBus().fire(new ReceivedXMLElementEvent(element2));
        }
    }

    private final void processTLSStanza(Element element2) {
        String string = element2.getName();
        if (Intrinsics.areEqual((Object)string, (Object)"proceed")) {
            this.proceedTLS();
        } else if (Intrinsics.areEqual((Object)string, (Object)"failure")) {
            Logger.DefaultImpls.warning$default(this.log, null, processTLSStanza.1.INSTANCE, 1, null);
            this.getHalcyon().getEventBus().fire(new SocketConnectionErrorEvent.TLSFailureEvent());
        } else {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
    }

    private final SSLSocketFactory getSocketFactory() {
        SSLContext ctx = SSLContext.getInstance("TLS");
        boolean $i$f$emptyArray = false;
        TrustManager[] trustManagerArray = new TrustManager[]{this.config.getTrustManager()};
        ctx.init((KeyManager[])((Object[])new KeyManager[0]), trustManagerArray, new SecureRandom());
        SSLSocketFactory sSLSocketFactory = ctx.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"ctx.socketFactory");
        return sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void proceedTLS() {
        Logger.DefaultImpls.info$default(this.log, null, proceedTLS.1.INSTANCE, 1, null);
        try {
            Logger.DefaultImpls.finest$default(this.log, null, proceedTLS.2.INSTANCE, 1, null);
            this.whiteSpaceEnabled = false;
            SSLSocketFactory factory = this.getSocketFactory();
            Socket socket = this.socket;
            if (socket == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                socket = null;
            }
            String string = this.config.getHostname();
            Socket socket2 = this.socket;
            if (socket2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                socket2 = null;
            }
            Socket socket3 = factory.createSocket(socket, string, socket2.getPort(), true);
            Intrinsics.checkNotNull((Object)socket3, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
            SSLSocket s1 = (SSLSocket)socket3;
            s1.setSoTimeout(0);
            s1.setKeepAlive(false);
            s1.setTcpNoDelay(true);
            s1.setUseClientMode(true);
            s1.addHandshakeCompletedListener(arg_0 -> SocketConnector.proceedTLS$lambda-0(this, arg_0));
            s1.startHandshake();
            SocketWorker socketWorker = this.worker;
            if (socketWorker == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                socketWorker = null;
            }
            socketWorker.setSocket(s1);
            this.restartStream();
        }
        catch (Throwable e) {
            this.setState(State.Disconnecting);
            this.getHalcyon().getEventBus().fire(this.createSocketConnectionErrorEvent(e));
        }
        finally {
            Logger.DefaultImpls.finest$default(this.log, null, proceedTLS.4.INSTANCE, 1, null);
            this.whiteSpaceEnabled = true;
        }
    }

    @Override
    @NotNull
    public SessionController createSessionController() {
        return new SocketSessionController(this.getHalcyon(), this);
    }

    private final void resolveTarget(Function1<? super List<Pair<String, Integer>>, Unit> completionHandler) {
        String location;
        List hosts = new ArrayList();
        Object object = (StreamManagementModule)this.getHalcyon().getModuleOrNull(StreamManagementModule.Companion);
        String string = object != null && (object = ((StreamManagementModule)object).getResumptionContext()) != null ? ((StreamManagementModule.ResumptionContext)object).getLocation() : (location = null);
        if (location != null) {
            ((Collection)hosts).add(new Pair((Object)location, (Object)this.config.getPort()));
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(location, this){
                final /* synthetic */ String $location;
                final /* synthetic */ SocketConnector this$0;
                {
                    this.$location = $location;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Using host " + this.$location + ':' + SocketConnector.access$getConfig$p(this.this$0).getPort();
                }
            }, 1, null);
            completionHandler.invoke((Object)hosts);
            return;
        }
        String seeOther = (String)this.getHalcyon().getInternalDataStore().getData(SEE_OTHER_HOST_KEY);
        if (seeOther != null) {
            ((Collection)hosts).add(new Pair((Object)seeOther, (Object)this.config.getPort()));
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(seeOther, this){
                final /* synthetic */ String $seeOther;
                final /* synthetic */ SocketConnector this$0;
                {
                    this.$seeOther = $seeOther;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Using host " + this.$seeOther + ':' + SocketConnector.access$getConfig$p(this.this$0).getPort();
                }
            }, 1, null);
            completionHandler.invoke((Object)hosts);
            return;
        }
        if (this.config.getHostname() != null) {
            Collection collection = hosts;
            String string2 = this.config.getHostname();
            Intrinsics.checkNotNull((Object)string2);
            collection.add(new Pair((Object)string2, (Object)this.config.getPort()));
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ SocketConnector this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Using host " + SocketConnector.access$getConfig$p(this.this$0).getHostname() + ':' + SocketConnector.access$getConfig$p(this.this$0).getPort();
                }
            }, 1, null);
            completionHandler.invoke((Object)hosts);
            return;
        }
        Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(this){
            final /* synthetic */ SocketConnector this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Resolving DNS of " + SocketConnector.access$getConfig$p(this.this$0).getDomain();
            }
        }, 1, null);
        this.config.getDnsResolver().resolve(this.config.getDomain(), (Function1<? super Result<? extends List<SrvRecord>>, Unit>)((Function1)new Function1<Result<? extends List<? extends SrvRecord>>, Unit>(completionHandler, (List<Pair<String, Integer>>)hosts, this){
            final /* synthetic */ Function1<List<Pair<String, Integer>>, Unit> $completionHandler;
            final /* synthetic */ List<Pair<String, Integer>> $hosts;
            final /* synthetic */ SocketConnector this$0;
            {
                this.$completionHandler = $completionHandler;
                this.$hosts = $hosts;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Object result) {
                Object it;
                Object object = result;
                List<Pair<String, Integer>> list = this.$hosts;
                SocketConnector socketConnector = this.this$0;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    it = throwable2;
                    boolean bl = false;
                    ((Collection)list).add(new Pair((Object)SocketConnector.access$getConfig$p(socketConnector).getDomain(), (Object)SocketConnector.access$getConfig$p(socketConnector).getPort()));
                }
                object = result;
                list = this.$hosts;
                if (Result.isSuccess-impl((Object)object)) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List it2 = (List)object;
                    boolean bl = false;
                    it = CollectionsKt.shuffled((Iterable)it2);
                    List<Pair<String, Integer>> list2 = list;
                    boolean $i$f$map = false;
                    void var9_11 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        SrvRecord srvRecord = (SrvRecord)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(new Pair((Object)it3.getTarget(), (Object)it3.getPort-pVg5ArA()));
                    }
                    list2.addAll((List)destination$iv$iv);
                }
                this.$completionHandler.invoke(this.$hosts);
            }
        }));
    }

    private final void createSocket(Function1<? super Socket, Unit> completionHandler) {
        this.resolveTarget((Function1<? super List<Pair<String, Integer>>, Unit>)((Function1)new Function1<List<? extends Pair<? extends String, ? extends Integer>>, Unit>(this, completionHandler){
            final /* synthetic */ SocketConnector this$0;
            final /* synthetic */ Function1<Socket, Unit> $completionHandler;
            {
                this.this$0 = $receiver;
                this.$completionHandler = $completionHandler;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<Pair<String, Integer>> hosts) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
                Iterable iterable = hosts;
                SocketConnector socketConnector = this.this$0;
                Function1<Socket, Unit> function1 = this.$completionHandler;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair hp = (Pair)element$iv;
                    boolean bl = false;
                    try {
                        Logger.DefaultImpls.fine$default(SocketConnector.access$getLog$p(socketConnector), null, (Function0)new Function0<Object>((Pair<String, Integer>)hp){
                            final /* synthetic */ Pair<String, Integer> $hp;
                            {
                                this.$hp = $hp;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Opening connection to " + (String)this.$hp.getFirst() + ':' + ((Number)this.$hp.getSecond()).intValue();
                            }
                        }, 1, null);
                        Socket s = new Socket((String)hp.getFirst(), ((Number)hp.getSecond()).intValue());
                        function1.invoke((Object)s);
                        return;
                    }
                    catch (Throwable e) {
                        Logger.DefaultImpls.fine$default(SocketConnector.access$getLog$p(socketConnector), null, (Function0)new Function0<Object>((Pair<String, Integer>)hp){
                            final /* synthetic */ Pair<String, Integer> $hp;
                            {
                                this.$hp = $hp;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Host " + (String)this.$hp.getFirst() + ':' + ((Number)this.$hp.getSecond()).intValue() + " is unreachable.";
                            }
                        }, 1, null);
                    }
                }
                throw new HostNotFound();
            }
        }));
    }

    @Override
    public void start() {
        this.setState(State.Connecting);
        BareJID userJid = ConfigurationKt.getDeclaredUserJID(this.getHalcyon().getConfig());
        ConnectionConfig connectionConfig = this.getHalcyon().getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        String domain = ((SocketConnectorConfig)connectionConfig).getDomain();
        try {
            this.createSocket((Function1<? super Socket, Unit>)((Function1)new Function1<Socket, Unit>(this, userJid, domain){
                final /* synthetic */ SocketConnector this$0;
                final /* synthetic */ BareJID $userJid;
                final /* synthetic */ String $domain;
                {
                    this.this$0 = $receiver;
                    this.$userJid = $userJid;
                    this.$domain = $domain;
                    super(1);
                }

                public final void invoke(@NotNull Socket sckt) {
                    StringBuilder stringBuilder;
                    Intrinsics.checkNotNullParameter((Object)sckt, (String)"sckt");
                    SocketConnector.access$setSocket$p(this.this$0, sckt);
                    Socket socket = SocketConnector.access$getSocket$p(this.this$0);
                    if (socket == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                        socket = null;
                    }
                    socket.setSoTimeout(20000);
                    Socket socket2 = SocketConnector.access$getSocket$p(this.this$0);
                    if (socket2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                        socket2 = null;
                    }
                    socket2.setKeepAlive(false);
                    Socket socket3 = SocketConnector.access$getSocket$p(this.this$0);
                    if (socket3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                        socket3 = null;
                    }
                    socket3.setTcpNoDelay(true);
                    Logger.DefaultImpls.fine$default(SocketConnector.access$getLog$p(this.this$0), null, (Function0)new Function0<Object>(this.this$0){
                        final /* synthetic */ SocketConnector this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            StringBuilder stringBuilder = new StringBuilder().append("Opening socket connection to ");
                            Socket socket = SocketConnector.access$getSocket$p(this.this$0);
                            if (socket == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                                socket = null;
                            }
                            return stringBuilder.append(socket.getInetAddress()).toString();
                        }
                    }, 1, null);
                    Socket socket4 = SocketConnector.access$getSocket$p(this.this$0);
                    if (socket4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                        socket4 = null;
                    }
                    SocketConnector.access$setWorker$p(this.this$0, new SocketWorker(socket4, SocketConnector.access$getParser$p(this.this$0)));
                    SocketWorker socketWorker = SocketConnector.access$getWorker$p(this.this$0);
                    if (socketWorker == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                        socketWorker = null;
                    }
                    socketWorker.setOnError((Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(this.this$0){
                        final /* synthetic */ SocketConnector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Exception exception) {
                            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                            SocketConnector.access$onWorkerException(this.this$0, exception);
                        }
                    }));
                    SocketWorker socketWorker2 = SocketConnector.access$getWorker$p(this.this$0);
                    if (socketWorker2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                        socketWorker2 = null;
                    }
                    socketWorker2.start();
                    BareJID bareJID = this.$userJid;
                    String string = this.$domain;
                    StringBuilder $this$invoke_u24lambda_u2d0 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    $this$invoke_u24lambda_u2d0.append("<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' ");
                    $this$invoke_u24lambda_u2d0.append("version='1.0' ");
                    if (bareJID != null) {
                        $this$invoke_u24lambda_u2d0.append("from='" + bareJID + "' ");
                    }
                    $this$invoke_u24lambda_u2d0.append("to='" + string + '\'');
                    $this$invoke_u24lambda_u2d0.append(">");
                    String string2 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                    String sb = string2;
                    this.this$0.send(sb);
                    SocketConnector.access$setState(this.this$0, State.Connected);
                    SocketConnector.access$getWhitespacePingExecutor$p(this.this$0).start();
                }
            }));
        }
        catch (HostNotFound e) {
            this.setState(State.Disconnected);
            this.getHalcyon().getEventBus().fire(new SocketConnectionErrorEvent.HostNotFount());
            this.setEventsEnabled(false);
        }
        catch (Exception e) {
            this.setState(State.Disconnected);
            this.getHalcyon().getEventBus().fire(this.createSocketConnectionErrorEvent(e));
            this.setEventsEnabled(false);
        }
    }

    private final void onWorkerException(Exception cause) {
        State state;
        cause.printStackTrace();
        this.getHalcyon().getEventBus().fire(this.createSocketConnectionErrorEvent(cause));
        switch (WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
            case 1: {
                state = State.Disconnected;
                break;
            }
            case 2: {
                state = State.Disconnecting;
                break;
            }
            case 3: {
                state = State.Disconnected;
                break;
            }
            case 4: {
                state = State.Disconnected;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.setState(state);
        if (this.getState() == State.Disconnected) {
            this.setEventsEnabled(false);
        }
    }

    private final SocketConnectionErrorEvent createSocketConnectionErrorEvent(Throwable cause) {
        Throwable throwable = cause;
        return (throwable instanceof UnknownHostException ? true : throwable instanceof DnssecValidationFailedException) ? (SocketConnectionErrorEvent)new SocketConnectionErrorEvent.HostNotFount() : (SocketConnectionErrorEvent)new SocketConnectionErrorEvent.Unknown(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.getState() != State.Disconnected) {
            Logger.DefaultImpls.fine$default(this.log, null, stop.1.INSTANCE, 1, null);
            try {
                SocketWorker socketWorker;
                if (this.getState() == State.Connected) {
                    this.closeStream();
                }
                this.setState(State.Disconnecting);
                this.whitespacePingExecutor.stop();
                Thread.sleep(175L);
                Socket socket = this.socket;
                if (socket == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                    socket = null;
                }
                if (!socket.isClosed()) {
                    SocketWorker socketWorker2 = this.worker;
                    if (socketWorker2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                        socketWorker2 = null;
                    }
                    socketWorker2.getWriter().close();
                    Socket socket2 = this.socket;
                    if (socket2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                        socket2 = null;
                    }
                    socket2.close();
                }
                if ((socketWorker = this.worker) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                    socketWorker = null;
                }
                socketWorker.interrupt();
                while (true) {
                    SocketWorker socketWorker3;
                    if ((socketWorker3 = this.worker) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                        socketWorker3 = null;
                    }
                    if (socketWorker3.isActive()) {
                        Thread.sleep(32L);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.setState(State.Disconnected);
                this.setEventsEnabled(false);
            }
        }
    }

    private final void closeStream() {
        if (this.getState() == State.Connected) {
            this.send("</stream:stream>");
        }
    }

    @Override
    public void send(@NotNull CharSequence data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Logger.DefaultImpls.finest$default(this.log, null, (Function0)new Function0<Object>(this, data){
                final /* synthetic */ SocketConnector this$0;
                final /* synthetic */ CharSequence $data;
                {
                    this.this$0 = $receiver;
                    this.$data = $data;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Sending (");
                    SocketWorker socketWorker = SocketConnector.access$getWorker$p(this.this$0);
                    if (socketWorker == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                        socketWorker = null;
                    }
                    StringBuilder stringBuilder2 = stringBuilder.append(socketWorker.getSocket().isConnected()).append(", ");
                    SocketWorker socketWorker2 = SocketConnector.access$getWorker$p(this.this$0);
                    if (socketWorker2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                        socketWorker2 = null;
                    }
                    return stringBuilder2.append(!socketWorker2.getSocket().isOutputShutdown()).append("): ").append((Object)this.$data).toString();
                }
            }, 1, null);
            SocketWorker socketWorker = this.worker;
            if (socketWorker == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                socketWorker = null;
            }
            socketWorker.getWriter().write(((Object)data).toString());
            SocketWorker socketWorker2 = this.worker;
            if (socketWorker2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                socketWorker2 = null;
            }
            socketWorker2.getWriter().flush();
        }
        catch (Exception e) {
            this.log.warning(e, (Function0<? extends Object>)((Function0)send.2.INSTANCE));
            this.setState(State.Disconnecting);
            this.getHalcyon().getEventBus().fire(this.createSocketConnectionErrorEvent(e));
            throw e;
        }
    }

    public final void restartStream() {
        StringBuilder stringBuilder;
        BareJID userJid = ConfigurationKt.getDeclaredUserJID(this.getHalcyon().getConfig());
        ConnectionConfig connectionConfig = this.getHalcyon().getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        String domain = ((SocketConnectorConfig)connectionConfig).getDomain();
        StringBuilder $this$restartStream_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$restartStream_u24lambda_u2d1.append("<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' ");
        $this$restartStream_u24lambda_u2d1.append("version='1.0' ");
        if (userJid != null) {
            $this$restartStream_u24lambda_u2d1.append("from='" + userJid + "' ");
        }
        $this$restartStream_u24lambda_u2d1.append("to='" + domain + '\'');
        $this$restartStream_u24lambda_u2d1.append(">");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String sb = string;
        this.send(sb);
    }

    private final void onTick() {
        if (this.getState() == State.Connected && this.whiteSpaceEnabled) {
            Logger.DefaultImpls.finer$default(this.log, null, onTick.1.INSTANCE, 1, null);
            SocketWorker socketWorker = this.worker;
            if (socketWorker == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                socketWorker = null;
            }
            socketWorker.getWriter().write(32);
            SocketWorker socketWorker2 = this.worker;
            if (socketWorker2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"worker");
                socketWorker2 = null;
            }
            socketWorker2.getWriter().flush();
        }
    }

    public final void startTLS() {
        Logger.DefaultImpls.info$default(this.log, null, startTLS.1.INSTANCE, 1, null);
        this.whiteSpaceEnabled = false;
        Element element2 = BuilderKt.element("starttls", (Function1<? super ElementNode, Unit>)((Function1)startTLS.element.1.INSTANCE));
        this.getHalcyon().getWriter().writeDirectly(element2);
    }

    private static final void proceedTLS$lambda-0(SocketConnector this$0, HandshakeCompletedEvent handshakeCompletedEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Logger.DefaultImpls.info$default(this$0.log, null, (Function0)new Function0<Object>(handshakeCompletedEvent){
            final /* synthetic */ HandshakeCompletedEvent $handshakeCompletedEvent;
            {
                this.$handshakeCompletedEvent = $handshakeCompletedEvent;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Handshake completed " + this.$handshakeCompletedEvent;
            }
        }, 1, null);
        this$0.secured = true;
    }

    public static final /* synthetic */ SocketConnectorConfig access$getConfig$p(SocketConnector $this) {
        return $this.config;
    }

    public static final /* synthetic */ Logger access$getLog$p(SocketConnector $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$setSocket$p(SocketConnector $this, Socket socket) {
        $this.socket = socket;
    }

    public static final /* synthetic */ Socket access$getSocket$p(SocketConnector $this) {
        return $this.socket;
    }

    public static final /* synthetic */ void access$setWorker$p(SocketConnector $this, SocketWorker socketWorker) {
        $this.worker = socketWorker;
    }

    public static final /* synthetic */ parser.1 access$getParser$p(SocketConnector $this) {
        return $this.parser;
    }

    public static final /* synthetic */ SocketWorker access$getWorker$p(SocketConnector $this) {
        return $this.worker;
    }

    public static final /* synthetic */ void access$onWorkerException(SocketConnector $this, Exception cause) {
        $this.onWorkerException(cause);
    }

    public static final /* synthetic */ void access$setState(SocketConnector $this, State value) {
        $this.setState(value);
    }

    public static final /* synthetic */ TickExecutor access$getWhitespacePingExecutor$p(SocketConnector $this) {
        return $this.whitespacePingExecutor;
    }

    public static final /* synthetic */ void access$onTick(SocketConnector $this) {
        $this.onTick();
    }

    public static final /* synthetic */ void access$processReceivedElement(SocketConnector $this, Element element2) {
        $this.processReceivedElement(element2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ltigase/halcyon/core/connector/socket/SocketConnector$Companion;", "", "()V", "SEE_OTHER_HOST_KEY", "", "SERVER_HOST", "SERVER_PORT", "XMLNS_START_TLS", "halcyon-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            nArray[State.Connecting.ordinal()] = 1;
            nArray[State.Connected.ordinal()] = 2;
            nArray[State.Disconnecting.ordinal()] = 3;
            nArray[State.Disconnected.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

