/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.auth;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Context;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xmpp.modules.auth.AuthData;
import tigase.halcyon.core.xmpp.modules.auth.ClientSaslException;
import tigase.halcyon.core.xmpp.modules.auth.SASLContext;
import tigase.halcyon.core.xmpp.modules.auth.SASLEvent;
import tigase.halcyon.core.xmpp.modules.auth.SASLMechanism;
import tigase.halcyon.core.xmpp.modules.auth.SASLModule;
import tigase.halcyon.core.xmpp.modules.auth.State;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016J\u0016\u0010\u001e\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 H\u0002J\u0014\u0010!\u001a\u00020\"2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011*\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/SASLEngine;", "", "context", "Ltigase/halcyon/core/Context;", "(Ltigase/halcyon/core/Context;)V", "getContext", "()Ltigase/halcyon/core/Context;", "log", "Ltigase/halcyon/core/logger/Logger;", "mechanisms", "", "Ltigase/halcyon/core/xmpp/modules/auth/SASLMechanism;", "saslContext", "Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", "getSaslContext$delegate", "(Ltigase/halcyon/core/xmpp/modules/auth/SASLEngine;)Ljava/lang/Object;", "getSaslContext", "()Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", "add", "", "mechanism", "evaluateChallenge", "", "data", "evaluateFailure", "", "saslError", "Ltigase/halcyon/core/xmpp/modules/auth/SASLModule$SASLError;", "errorText", "evaluateSuccess", "selectMechanism", "allowedMechanisms", "", "start", "Ltigase/halcyon/core/xmpp/modules/auth/AuthData;", "halcyon-core"})
public final class SASLEngine {
    @NotNull
    private final Context context;
    @NotNull
    private final Logger log;
    @NotNull
    private final List<SASLMechanism> mechanisms;

    public SASLEngine(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.xmpp.modules.auth.SASLEngine", false, 2, null);
        this.mechanisms = new ArrayList();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final SASLContext getSaslContext() {
        return this.context.getAuthContext();
    }

    public static Object getSaslContext$delegate(SASLEngine sASLEngine) {
        Intrinsics.checkNotNullParameter((Object)sASLEngine, (String)"<this>");
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)sASLEngine.context, Context.class, "authContext", "getAuthContext()Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", 0)));
    }

    private final SASLMechanism selectMechanism(List<String> allowedMechanisms) {
        for (SASLMechanism mechanism : this.mechanisms) {
            Logger.DefaultImpls.finer$default(this.log, null, (Function0)new Function0<Object>(mechanism){
                final /* synthetic */ SASLMechanism $mechanism;
                {
                    this.$mechanism = $mechanism;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Checking mechanism " + this.$mechanism.getName();
                }
            }, 1, null);
            if (!allowedMechanisms.contains(mechanism.getName()) || !mechanism.isAllowedToUse(this.context.getConfig(), this.getSaslContext())) continue;
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(mechanism){
                final /* synthetic */ SASLMechanism $mechanism;
                {
                    this.$mechanism = $mechanism;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Selected mechanism: " + this.$mechanism.getName();
                }
            }, 1, null);
            return mechanism;
        }
        throw new HalcyonException("None of known SASL mechanism is supported by server");
    }

    public final boolean add(@NotNull SASLMechanism mechanism) {
        Intrinsics.checkNotNullParameter((Object)mechanism, (String)"mechanism");
        return this.mechanisms.add(mechanism);
    }

    @NotNull
    public final AuthData start(@NotNull List<String> allowedMechanisms) {
        Intrinsics.checkNotNullParameter(allowedMechanisms, (String)"allowedMechanisms");
        this.getSaslContext().setState$halcyon_core(State.InProgress);
        SASLMechanism mechanism = this.selectMechanism(allowedMechanisms);
        String authData = mechanism.evaluateChallenge(null, this.context.getConfig(), this.getSaslContext());
        this.getSaslContext().setMechanism$halcyon_core(mechanism);
        this.context.getEventBus().fire(new SASLEvent.SASLStarted(mechanism.getName()));
        return new AuthData(mechanism.getName(), authData);
    }

    @Nullable
    public final String evaluateChallenge(@Nullable String data) {
        SASLMechanism sASLMechanism = this.getSaslContext().getMechanism();
        if (sASLMechanism == null) {
            throw new ClientSaslException("SASL Context is empty");
        }
        SASLMechanism mechanism = sASLMechanism;
        if (this.getSaslContext().getComplete()) {
            throw new ClientSaslException("Mechanism " + mechanism.getName() + " is finished but Server sent challenge.");
        }
        String r = mechanism.evaluateChallenge(data, this.context.getConfig(), this.getSaslContext());
        return r;
    }

    public final void evaluateSuccess(@Nullable String data) {
        SASLMechanism sASLMechanism = this.getSaslContext().getMechanism();
        if (sASLMechanism == null) {
            throw new ClientSaslException("SASL Context is empty");
        }
        SASLMechanism mechanism = sASLMechanism;
        mechanism.evaluateChallenge(data, this.context.getConfig(), this.getSaslContext());
        if (!this.getSaslContext().getComplete()) {
            this.getSaslContext().setState$halcyon_core(State.Failed);
            throw new ClientSaslException("Invalid state of SASL Engine");
        }
        this.getSaslContext().setState$halcyon_core(State.Success);
        this.context.getEventBus().fire(new SASLEvent.SASLSuccess());
    }

    public final void evaluateFailure(@NotNull SASLModule.SASLError saslError, @Nullable String errorText) {
        Intrinsics.checkNotNullParameter((Object)((Object)saslError), (String)"saslError");
        this.getSaslContext().setState$halcyon_core(State.Failed);
        this.context.getEventBus().fire(new SASLEvent.SASLError(saslError, errorText));
    }
}

