/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.worker;

import java.util.UUID;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.dacframe.Agent;
import org.dacframe.AgentBroker;
import org.dacframe.CacheService;
import org.dacframe.DACException;
import org.dacframe.spring.GaspsApplicationContext;

public class WorkerSingleThreaded
implements Runnable {
    private static Logger logger;
    private CacheService cs;
    private AgentBroker ab;
    final String workerId = UUID.randomUUID().toString();
    private boolean stopWorking;

    @Override
    public void run() {
        Thread.currentThread().setName(this.workerId);
        ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout());
        logger.addAppender((Appender)appender);
        logger.info((Object)("Single threaded worker " + this.workerId + " started"));
        logger.removeAppender((Appender)appender);
        do {
            try {
                this.ab.startTransaction();
                logger.debug((Object)("Worker " + this.workerId + " is receiving agent..."));
                Agent agent = this.ab.receiveAgent();
                if (agent != null) {
                    logger.info((Object)("Worker " + this.workerId + " is executing agent: " + agent));
                    this.injectServices(agent);
                    agent.execute();
                } else {
                    logger.warn((Object)("Worker " + this.workerId + " received null agent!"));
                }
                this.ab.commit();
            }
            catch (DACException de) {
                logger.error((Object)"DACException - stop working", (Throwable)de);
                this.stopWorking = true;
            }
            catch (Exception e) {
                logger.error((Object)("Exception thrown in worker " + this.workerId + " rollbacking last transaction"), (Throwable)e);
                try {
                    this.ab.rollback();
                }
                catch (DACException e1) {
                    logger.error((Object)("Exception thrown in worker " + this.workerId + " during rollback!"), (Throwable)e);
                }
            }
        } while (!this.stopWorking);
        logger.info((Object)("Worker " + this.workerId + " stops working..."));
    }

    private void injectServices(Agent agent) {
        agent.setCacheService(this.cs);
        agent.setAgentManager(this.ab);
        agent.setLogger(logger);
    }

    public void setCacheService(CacheService cs) {
        this.cs = cs;
    }

    public void setAgentBroker(AgentBroker ab) {
        this.ab = ab;
    }

    public void setStopWorking(boolean stopWorking) {
        this.stopWorking = stopWorking;
    }

    public static void main(String[] args) {
        WorkerSingleThreaded worker = (WorkerSingleThreaded)GaspsApplicationContext.getContext().getBean("workerSingleThreaded");
        worker.run();
    }

    static {
        LogLog.setQuietMode((boolean)true);
        logger = Logger.getLogger(WorkerSingleThreaded.class);
    }
}

