/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.worker;

import gnu.cajo.utils.extra.TransparentItemProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.dacframe.Agent;
import org.dacframe.AgentBroker;
import org.dacframe.DACException;
import org.dacframe.broker.AgentBrokerCajo;
import org.dacframe.broker.CajoBroker;
import org.dacframe.broker.SerializationUtils;
import org.dacframe.spring.GaspsApplicationContext;

public class WorkerGAE
implements Runnable {
    private static int NUMBER_OF_WORKERS = Integer.parseInt(System.getProperty("no_workers_gae", "6"));
    private static Logger logger;
    private AgentBroker ab;
    final String workerId = UUID.randomUUID().toString();
    private String urlGAE;
    private boolean stopWorking;
    private String brokerURL;
    private String sessionId;
    private Map<String, URLClassLoader> sessionToClassLoaderMap = new HashMap<String, URLClassLoader>();
    public static final String sendKey = "<send>";
    public static final String receiveKey = "<receive>";
    public static final String loadClassKey = "<loadClass>";
    public static final String classLoadedKey = "<classLoaded>";

    @Override
    public void run() {
        Thread.currentThread().setName(this.workerId);
        ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout());
        logger.addAppender((Appender)appender);
        logger.info((Object)("Google App Engine worker " + this.workerId + " started"));
        logger.removeAppender((Appender)appender);
        while (true) {
            if (this.stopWorking) break;
            try {
                this.ab.startTransaction();
                Agent agent = this.ab.receiveAgent();
                logger.info((Object)("Worker " + this.workerId + " is receiving agent..."));
                if (agent != null) {
                    logger.info((Object)("Worker " + this.workerId + " is executing agent: " + agent));
                    ArrayList<Agent> request = new ArrayList<Agent>();
                    request.add(agent);
                    this.sessionId = agent.getSession().getSessionId();
                    Map googleResult = this.sendGoogle(request);
                    this.doResults(googleResult, agent);
                } else {
                    logger.warn((Object)("Worker " + this.workerId + " received null agent!"));
                }
                this.ab.commit();
            }
            catch (DACException de) {
                logger.error((Object)("DACException - stop working\n" + de), (Throwable)de);
                this.stopWorking = true;
            }
            catch (Exception e) {
                logger.error((Object)("Exception thrown in worker " + this.workerId + " rollbacking last transaction\n" + e), (Throwable)e);
                try {
                    this.ab.rollback();
                }
                catch (DACException e1) {
                    logger.error((Object)("Exception thrown in worker " + this.workerId + " during rollback!\n" + e));
                }
            }
        }
        logger.info((Object)("Worker " + this.workerId + " stops working..."));
    }

    private void doResults(Map googleResult, Agent agent) throws DACException {
        if (googleResult.size() > 0) {
            for (Object key : googleResult.keySet()) {
                ArrayList<Object> request;
                Vector data;
                if (key.equals(sendKey)) {
                    data = (Vector)googleResult.get((String)key);
                    if (data.size() % 2 == 0 && data.get(0).getClass().getSimpleName().equalsIgnoreCase("Integer")) {
                        for (int i = 0; i < data.size(); i += 2) {
                            this.ab.sendAgent((Agent)data.get(i + 1), (Integer)data.get(i));
                        }
                        continue;
                    }
                    for (Object a : data) {
                        this.ab.sendAgent((Agent)a);
                    }
                    continue;
                }
                if (key.equals(receiveKey)) {
                    data = (Vector)googleResult.get((String)key);
                    String receiveString = (String)data.get(0);
                    ArrayList<Object> request2 = new ArrayList<Object>();
                    List<Object> results = this.ab.receiveAgentResults(receiveString);
                    if (data.size() == 1 && results.size() > 0 || data.size() == 2 && results.size() == ((Integer)data.get(1)).intValue()) {
                        request2.add(agent);
                        request2.add(results);
                        request2.add(receiveString);
                        Map finalResult = this.sendGoogle(request2);
                        this.doResults(finalResult, agent);
                        continue;
                    }
                    this.ab.sendAgent(agent);
                    continue;
                }
                if (key.equals(loadClassKey)) {
                    request = new ArrayList<Object>();
                    AgentBrokerCajo broker = null;
                    try {
                        broker = (AgentBrokerCajo)TransparentItemProxy.getItem((String)this.brokerURL, (Class[])new Class[]{AgentBrokerCajo.class});
                    }
                    catch (Exception e) {
                        logger.error((Object)("Could not run Agent Broker " + e), (Throwable)e);
                    }
                    request.add(broker.getSessionJar(this.sessionId));
                    request.add(0);
                    Map finalResult = this.sendGoogle(request);
                    this.doResults(finalResult, agent);
                    continue;
                }
                if (key.equals(classLoadedKey)) {
                    request = new ArrayList();
                    request.add(agent);
                    Map finalResult = this.sendGoogle(request);
                    this.doResults(finalResult, agent);
                    continue;
                }
                for (Object value : (Vector)googleResult.get((String)key)) {
                    this.ab.putResult((String)key, value);
                }
            }
        }
    }

    private Map sendGoogle(Object request) {
        Map map = null;
        try {
            int read;
            URL url = new URL(this.urlGAE);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoOutput(true);
            OutputStream out = urlConnection.getOutputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(request);
            oos.flush();
            oos.close();
            bos.close();
            byte[] imageBytes = bos.toByteArray();
            out.write(imageBytes);
            out.flush();
            out.close();
            logger.info((Object)" Sent agent to server");
            InputStream is = urlConnection.getInputStream();
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            byte[] buffer = new byte[3000];
            do {
                if ((read = is.read(buffer, 0, buffer.length)) <= 0) continue;
                buf.write(buffer, 0, read);
            } while (read >= 0);
            is.close();
            map = this.readObject(buf.toByteArray());
            logger.info((Object)" Received results from server");
        }
        catch (Exception e) {
            logger.error((Object)("Exception: " + e), (Throwable)e);
        }
        return map;
    }

    private Map readObject(byte[] byteArray) throws DACException {
        Map map = new HashMap();
        URLClassLoader classLoader = this.sessionToClassLoaderMap.get(this.sessionId);
        try {
            if (classLoader == null) {
                AgentBrokerCajo broker = (AgentBrokerCajo)TransparentItemProxy.getItem((String)this.brokerURL, (Class[])new Class[]{AgentBrokerCajo.class});
                byte[] jarDef = broker.getSessionJar(this.sessionId);
                classLoader = jarDef != null ? SerializationUtils.createNewJarClassLoader(SerializationUtils.storeSessionJar(this.sessionId, jarDef)) : new URLClassLoader(new URL[0]);
                this.sessionToClassLoaderMap.put(this.sessionId, classLoader);
            }
            map = (Map)SerializationUtils.byteArrayToObject(byteArray, classLoader);
        }
        catch (Exception e) {
            logger.error((Object)("Exception: " + e), (Throwable)e);
        }
        return map;
    }

    public void setAgentBroker(AgentBroker ab) {
        this.ab = ab;
    }

    public void setUrlGAE(String urlGAE) {
        this.urlGAE = urlGAE;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }

    public void setStopWorking(boolean stopWorking) {
        this.stopWorking = stopWorking;
    }

    public static void main(String[] args) throws ClassNotFoundException, IOException, NotBoundException, InterruptedException, IllegalAccessException, InstantiationException {
        if (args.length == 2) {
            for (int i = 0; i < NUMBER_OF_WORKERS; ++i) {
                WorkerGAE worker = new WorkerGAE();
                worker.setUrlGAE(args[0]);
                worker.setAgentBroker(new CajoBroker(args[1]));
                worker.setBrokerURL(args[1]);
                new Thread(worker).start();
            }
        } else {
            ((WorkerGAE)GaspsApplicationContext.getContext().getBean("workerGAE")).run();
        }
    }

    static {
        LogLog.setQuietMode((boolean)true);
        logger = Logger.getLogger(WorkerGAE.class);
    }
}

