/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.worker;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import org.dacframe.Agent;
import org.dacframe.AgentBroker;
import org.dacframe.DACException;
import org.dacframe.broker.AgentExecutorService;

public class GoogleAgentBroker
implements AgentBroker {
    private Map<String, List<Object>> responseMap = new Hashtable<String, List<Object>>();
    private Map<String, List<Object>> requestedResults = new Hashtable<String, List<Object>>();
    private String sendKey = "<send>";
    private String receiveKey = "<receive>";

    @Override
    public void sendAgent(Agent agent, int i) throws DACException {
        if (this.responseMap.get(this.sendKey) == null) {
            this.responseMap.put(this.sendKey, new Vector());
        }
        this.responseMap.get(this.sendKey).add(i);
        this.responseMap.get(this.sendKey).add(agent);
    }

    @Override
    public void sendAgent(Agent agent) throws DACException {
        if (this.responseMap.get(this.sendKey) == null) {
            this.responseMap.put(this.sendKey, new Vector());
        }
        this.responseMap.get(this.sendKey).add(agent);
    }

    @Override
    public void putResult(String s, Object o) throws DACException {
        if (this.responseMap.get(s) == null) {
            this.responseMap.put(s, new Vector());
        }
        this.responseMap.get(s).add(o);
    }

    @Override
    public List<Object> receiveAgentResults(String s) throws DACException {
        if (this.requestedResults.get(s) == null) {
            this.requestedResults.put(s, new Vector());
        }
        if (this.requestedResults.get(s).size() > 0) {
            return this.requestedResults.get(s);
        }
        this.responseMap.put(this.receiveKey, new Vector());
        this.responseMap.get(this.receiveKey).add(s);
        throw new DACException("Agent " + s + " must wait to receive results.");
    }

    @Override
    public List<Object> receiveAgentResults(String s, int i) throws DACException {
        if (this.requestedResults.get(s) == null) {
            this.requestedResults.put(s, new Vector());
        }
        if (this.requestedResults.get(s).size() == i) {
            return this.requestedResults.get(s);
        }
        this.responseMap.put(this.receiveKey, new Vector());
        this.responseMap.get(this.receiveKey).add(s);
        this.responseMap.get(this.receiveKey).add(i);
        throw new DACException("Agent " + s + " must wait to receive results.");
    }

    @Override
    public ExecutorService getExecutorService() throws DACException {
        return new AgentExecutorService("");
    }

    @Override
    public void startTransaction() throws DACException {
    }

    @Override
    public Agent receiveAgent() throws DACException {
        return null;
    }

    @Override
    public void commit() throws DACException {
    }

    @Override
    public void rollback() throws DACException {
    }

    public Map<String, List<Object>> getResponseMap() {
        return this.responseMap;
    }

    public void setRequestedResults(List results, String id) {
        if (this.requestedResults.get(id) == null) {
            this.requestedResults.put(id, new Vector());
        }
        for (Object o : results) {
            this.requestedResults.get(id).add(o);
        }
    }
}

