/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.worker;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheManager;
import org.dacframe.Agent;
import org.dacframe.broker.SerializationUtils;
import org.dacframe.cs.CacheServiceHM;
import org.dacframe.worker.GClassLoader;
import org.dacframe.worker.GWorker;
import org.dacframe.worker.GoogleAgentBroker;

public class DACFrameServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(DACFrameServlet.class.getName());
    public static final String registerCache = "DACCache";
    private Cache cache;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int read;
        log.info("Request Content Type " + req.getContentType());
        if (CacheManager.getInstance().getCache(registerCache) == null) {
            try {
                this.cache = CacheManager.getInstance().getCacheFactory().createCache(Collections.emptyMap());
                CacheManager.getInstance().registerCache(registerCache, this.cache);
            }
            catch (CacheException e) {
                throw new ServletException("Could not initialize cache:", (Throwable)e);
            }
        } else {
            this.cache = CacheManager.getInstance().getCache(registerCache);
        }
        ServletInputStream is = req.getInputStream();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] buffer = new byte[3000];
        do {
            if ((read = is.read(buffer, 0, buffer.length)) <= 0) continue;
            buf.write(buffer, 0, read);
        } while (read >= 0);
        is.close();
        try {
            GoogleAgentBroker gab = new GoogleAgentBroker();
            GClassLoader classLoader = new GClassLoader(this.cache);
            List reqList = (List)SerializationUtils.byteArrayToObject(buf.toByteArray(), classLoader);
            if (reqList.size() == 2) {
                log.info("Received missing classes.");
                this.doJar((byte[])reqList.get(0));
                Hashtable responseMap = new Hashtable();
                responseMap.put("<classLoaded>", new Vector());
                this.send(responseMap, resp);
            } else {
                Agent agent = (Agent)reqList.get(0);
                log.info("Received agent: " + agent.getIdentString());
                GWorker worker = new GWorker(agent);
                if (reqList.size() == 3) {
                    gab.setRequestedResults((List)reqList.get(1), (String)reqList.get(2));
                }
                worker.setCacheService(new CacheServiceHM());
                worker.setAgentBroker(gab);
                worker.run();
                log.info("Sending response");
                this.send(gab.getResponseMap(), resp);
            }
        }
        catch (ClassNotFoundException e) {
            log.info(e.getMessage() + "\n      Asking to send missing class");
            Hashtable responseMap = new Hashtable();
            responseMap.put("<loadClass>", new Vector());
            this.send(responseMap, resp);
        }
    }

    private void send(Object response, HttpServletResponse resp) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(response);
        oos.flush();
        oos.close();
        bos.close();
        byte[] b = bos.toByteArray();
        resp.setContentLength(b.length);
        ServletOutputStream servletOut = resp.getOutputStream();
        servletOut.write(b);
        servletOut.close();
    }

    private void doJar(byte[] data) {
        try {
            JarEntry jarEntry;
            JarInputStream jarFile = new JarInputStream(new ByteArrayInputStream(data));
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                if (!jarEntry.getName().endsWith(".class")) continue;
                log.info("Found " + jarEntry.getName().replaceAll("/", "\\."));
                this.loadClassBytes(jarFile, jarEntry.getName().replaceAll("/", "\\."));
                jarFile.closeEntry();
            }
        }
        catch (Exception e) {
            log.severe("Badly formatted jar file");
            e.printStackTrace();
        }
    }

    private void loadClassBytes(JarInputStream jis, String jarName) {
        BufferedInputStream jarBuf = new BufferedInputStream(jis);
        ByteArrayOutputStream jarOut = new ByteArrayOutputStream();
        try {
            int b;
            while ((b = jarBuf.read()) != -1) {
                jarOut.write(b);
            }
            this.cache.put((Object)jarName.substring(0, jarName.length() - 6), (Object)jarOut.toByteArray());
        }
        catch (IOException e) {
            log.severe("Error reading entry " + jarName);
            e.printStackTrace();
        }
    }
}

