/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import java.util.ArrayList;
import java.util.List;
import org.dacframe.Agent;
import org.dacframe.DACException;
import org.dacframe.broker.AgentBrokerStub;
import org.dacframe.broker.AgentEntry;
import org.dacframe.broker.QueueElem;
import org.dacframe.broker.ReceiveAgentEntry;
import org.dacframe.broker.ReceivedResultsEntry;
import org.dacframe.broker.ResultEntry;
import org.dacframe.broker.TransactionEntry;

class TransactionDAC {
    private long transactionId;
    private AgentBrokerStub ab;
    private List<TransactionEntry> entries = new ArrayList<TransactionEntry>();
    private long creationTime = System.currentTimeMillis();

    TransactionDAC(long transactionId, AgentBrokerStub ab) {
        this.transactionId = transactionId;
        this.ab = ab;
    }

    public void putResult(String sessionId, String addresseeIdentString, Object result) {
        this.entries.add(new ResultEntry(sessionId, addresseeIdentString, result));
    }

    public void putAgent(Agent agent, int priority) {
        this.entries.add(new AgentEntry(agent, priority));
    }

    public List<Object> receiveAgentResults(String sessionId, String recipientIdentString, int requiredResults) throws DACException {
        List<Object> results = this.ab.receiveAgentResults(recipientIdentString, requiredResults);
        this.entries.add(new ReceivedResultsEntry(sessionId, recipientIdentString, results));
        return results;
    }

    public List<Object> receiveAgentResults(String sessionId, String recipientIdentString) throws DACException {
        List<Object> results = this.ab.receiveAgentResults(recipientIdentString);
        this.entries.add(new ReceivedResultsEntry(sessionId, recipientIdentString, results));
        return results;
    }

    public Agent receiveAgent() {
        QueueElem elem = this.ab.takeAgent();
        this.entries.add(new ReceiveAgentEntry(elem));
        return elem.agent;
    }

    public void commit() throws DACException {
        for (TransactionEntry entry : this.entries) {
            entry.commit(this.ab);
        }
    }

    public void rollback() throws DACException {
        for (TransactionEntry entry : this.entries) {
            entry.rollback(this.ab);
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public boolean isValidForRollback() {
        return !this.entries.isEmpty();
    }

    public String getSessionId() {
        if (this.entries.isEmpty()) {
            return null;
        }
        return this.entries.get(0).getSessionId();
    }
}

