/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.ByteSequence;
import org.dacframe.DACException;

public abstract class SerializationUtils {
    public static byte[] objectToByteArray(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(object);
        out.flush();
        out.close();
        return baos.toByteArray();
    }

    public static Object byteArrayToObject(byte[] byteArray, final ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        ObjectInputStream in = new ObjectInputStream(bais){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String className = desc.getName();
                if (classLoader != null) {
                    return Class.forName(className, false, classLoader);
                }
                return Class.forName(className);
            }
        };
        Object object = in.readObject();
        in.close();
        return object;
    }

    public static byte[] loadClassDef(String className, ClassLoader classLoader) throws IOException {
        int read;
        className = className.replace('.', '/') + ".class";
        URL path = classLoader != null ? classLoader.getResource(className) : ClassLoader.getSystemResource(className);
        if (path == null) {
            throw new NullPointerException("Path to the class to load (" + className + ") is null!");
        }
        InputStream is = path.openStream();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] buffer = new byte[3000];
        do {
            if ((read = is.read(buffer, 0, buffer.length)) <= 0) continue;
            buf.write(buffer, 0, read);
        } while (read >= 0);
        is.close();
        return buf.toByteArray();
    }

    public static URLClassLoader createNewUrlClassLoader(String sessionId) throws DACException {
        URLClassLoader classLoader;
        File sessionDir = new File(System.getProperty("org.dacframe.class.repository", ".sessions") + File.separator + sessionId + File.separator);
        sessionDir.mkdirs();
        try {
            classLoader = new URLClassLoader(new URL[]{sessionDir.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            throw new DACException(e);
        }
        return classLoader;
    }

    public static Set<String> storeClassDefinition(String sessionId, String className, byte[] classDef) throws DACException {
        HashSet<String> missingClasses = new HashSet<String>();
        String fileName = className.replace('.', '/') + ".class";
        File destination = new File(System.getProperty("org.dacframe.class.repository", ".sessions") + File.separator + sessionId + File.separator + fileName);
        File pathFile = new File(destination.getParent());
        pathFile.mkdirs();
        try {
            FileOutputStream fileOutput = new FileOutputStream(destination);
            fileOutput.write(classDef);
            fileOutput.flush();
            fileOutput.close();
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        try {
            ClassParser parser = new ClassParser(destination.getAbsolutePath());
            JavaClass aClass = parser.parse();
            for (Attribute attribute : aClass.getAttributes()) {
                if (!(attribute instanceof InnerClasses)) continue;
                InnerClasses innerClasses = (InnerClasses)attribute;
                for (InnerClass innterClass : innerClasses.getInnerClasses()) {
                    String innerClassName = SerializationUtils.extractClassName(innerClasses.getConstantPool().getConstantString(innterClass.getInnerClassIndex(), (byte)7));
                    if (className.equals(innerClassName)) continue;
                    missingClasses.add(innerClassName);
                }
            }
            for (Attribute attribute : aClass.getMethods()) {
                LocalVariableTable table = attribute.getLocalVariableTable();
                Code methodCode = attribute.getCode();
                ByteSequence stream = new ByteSequence(methodCode.getCode());
                while (stream.available() > 0) {
                    String codeString = Utility.codeToString((ByteSequence)stream, (ConstantPool)methodCode.getConstantPool(), (boolean)false);
                    if (!codeString.startsWith("new\t")) continue;
                    missingClasses.add(codeString.substring(codeString.indexOf(60) + 1, codeString.indexOf(62)));
                }
                if (table == null) continue;
                for (LocalVariable localVariable : table.getLocalVariableTable()) {
                    String localVariableName = SerializationUtils.extractClassName(localVariable.getSignature());
                    if ("Z".equals(localVariableName) || "C".equals(localVariableName) || "F".equals(localVariableName) || "D".equals(localVariableName) || "B".equals(localVariableName) || "S".equals(localVariableName) || "I".equals(localVariableName) || "J".equals(localVariableName) || "V".equals(localVariableName) || className.equals(localVariableName)) continue;
                    missingClasses.add(localVariableName);
                }
            }
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        return missingClasses;
    }

    public static String extractClassName(String className) {
        while (className.startsWith("[")) {
            className = className.substring(1);
        }
        if (className.startsWith("L")) {
            className = className.substring(1);
        }
        if (className.endsWith(";")) {
            className = className.substring(0, className.length() - 1);
        }
        className = className.replace('/', '.');
        return className;
    }

    public static URLClassLoader createNewJarClassLoader(String path) throws DACException {
        URLClassLoader classLoader;
        File sessionJar = new File(path);
        try {
            classLoader = new URLClassLoader(new URL[]{sessionJar.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            throw new DACException(e);
        }
        return classLoader;
    }

    public static String storeSessionJar(String sessionId, byte[] jarDef) throws DACException {
        try {
            File destination = File.createTempFile("DACsession", sessionId);
            FileOutputStream fileOutput = new FileOutputStream(destination);
            fileOutput.write(jarDef);
            fileOutput.flush();
            fileOutput.close();
            return destination.getAbsolutePath();
        }
        catch (IOException e) {
            throw new DACException(e);
        }
    }
}

