/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.dacframe.DACException;
import org.dacframe.broker.CajoBroker;

public class FutureDAC<T>
implements Future<T>,
Serializable {
    private static Logger log = Logger.getLogger(FutureDAC.class);
    private transient CajoBroker broker;
    private String brokerUrl;
    private String identString;
    private int type;
    private T t;
    private boolean done = false;
    private Object result;

    public FutureDAC(String brokerUrl, String identString, int type) {
        this.brokerUrl = brokerUrl;
        this.identString = identString;
        this.type = type;
        this.isBroker();
    }

    public FutureDAC(String brokerUrl, String identString, int type, T t) {
        this.brokerUrl = brokerUrl;
        this.identString = identString;
        this.type = type;
        this.t = t;
        this.isBroker();
    }

    private void isBroker() {
        if (this.broker == null) {
            try {
                this.broker = new CajoBroker(this.brokerUrl);
            }
            catch (NotBoundException e) {
                log.error((Object)e);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e);
            }
            catch (InstantiationException e) {
                log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
        }
    }

    @Override
    public boolean cancel(boolean b) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        this.isBroker();
        try {
            List<Object> results = this.broker.receiveAgentResults(this.identString);
            if (results.size() > 0) {
                this.result = results.get(0);
                this.done = true;
            }
        }
        catch (DACException e) {
            throw new RejectedExecutionException(e);
        }
        return this.done;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.isBroker();
        Object res = null;
        while (!this.isDone()) {
            Thread.sleep(100L);
        }
        switch (this.type) {
            case 1: {
                if (this.result.getClass().getName().endsWith("Exception")) {
                    throw new ExecutionException((Exception)this.result);
                }
                res = this.result;
                break;
            }
            case 2: {
                res = null;
                break;
            }
            case 3: {
                res = this.t;
            }
        }
        return (T)res;
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long time;
        this.isBroker();
        long start = System.currentTimeMillis();
        long end = TimeUnit.MILLISECONDS.convert(l, timeUnit) + start;
        Object res = null;
        do {
            Thread.sleep(100L);
            time = end - System.currentTimeMillis();
        } while (!this.isDone() && time >= 0L);
        switch (this.type) {
            case 1: {
                res = this.result;
                break;
            }
            case 2: {
                res = null;
                break;
            }
            case 3: {
                res = this.t;
            }
        }
        if (time < 0L) {
            throw new TimeoutException();
        }
        return (T)res;
    }
}

