/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import java.io.IOException;
import java.rmi.NotBoundException;
import java.util.List;
import org.dacframe.DACException;
import org.dacframe.agent.AgentStub;
import org.dacframe.broker.ActiveMQBroker;
import org.dacframe.broker.CajoBroker;
import org.junit.Assert;
import org.junit.Test;

public class EnvironmentInitTest {
    @Test
    public void cajoBrokerInitTest() throws DACException, InterruptedException, ClassNotFoundException, IOException, NotBoundException, IllegalAccessException, InstantiationException {
        CajoBroker ab = new CajoBroker("//localhost:1198/broker");
        AgentStub addressee = new AgentStub();
        ab.startTransaction();
        AgentStub agent = new AgentStub(null, addressee);
        ab.sendAgent(agent);
        ab.commit();
        ab.startTransaction();
        String result = null;
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            List<Object> resultList = ab.receiveAgentResults(addressee.getIdentString());
            if (resultList.size() <= 0) continue;
            Assert.assertEquals((long)1L, (long)resultList.size());
            result = (String)resultList.get(0);
            break;
        }
        ab.commit();
        Assert.assertEquals((Object)agent.getIdentString(), result);
    }

    @Test
    public void jmsBrokerInitTest() throws DACException, InterruptedException {
        ActiveMQBroker ab = new ActiveMQBroker("tcp://localhost:61616");
        AgentStub addressee = new AgentStub();
        ab.startTransaction();
        AgentStub agent = new AgentStub(null, addressee);
        ab.sendAgent(agent);
        ab.commit();
        ab.startTransaction();
        String result = null;
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            List<Object> resultList = ab.receiveAgentResults(addressee.getIdentString());
            if (resultList.size() <= 0) continue;
            Assert.assertEquals((long)1L, (long)resultList.size());
            result = (String)resultList.get(0);
            break;
        }
        ab.commit();
        Assert.assertEquals((Object)agent.getIdentString(), result);
    }
}

