/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.dacframe.Agent;
import org.dacframe.DACException;
import org.dacframe.agent.AgentStub;
import org.dacframe.broker.CajoBroker;
import org.dacframe.broker.CajoBrokerServer;
import org.dacframe.session.SessionInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CajoBrokerTest {
    private static Logger log = Logger.getLogger(CajoBrokerTest.class);
    private CajoBroker ab;
    private CajoBrokerServer cajoServer;
    private String testValue = "abc";
    private Thread cajoServerThread = new Thread(){

        @Override
        public void run() {
            try {
                CajoBrokerTest.this.cajoServer = new CajoBrokerServer("localhost");
            }
            catch (UnknownHostException e) {
                log.error((Object)e);
            }
            catch (RemoteException e) {
                log.error((Object)e);
            }
        }
    };

    @Before
    public void setUp() throws Exception {
        this.cajoServerThread.start();
        Thread.sleep(2500L);
        this.ab = new CajoBroker("//localhost:1198/broker");
    }

    @After
    public void tearDown() throws Exception {
        this.cajoServer.cleanup();
    }

    @Test
    public void sendReceiveResult() throws DACException {
        AgentStub agent = new AgentStub();
        Integer result = 222;
        this.ab.startTransaction();
        this.ab.putResult(agent.getIdentString(), result);
        this.ab.commit();
        this.ab.startTransaction();
        List<Object> results = this.ab.receiveAgentResults(agent.getIdentString());
        this.ab.commit();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)222, (Object)results.get(0));
    }

    @Test
    public void sendReceiveManyResults() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        for (int i = 0; i < 100; ++i) {
            this.ab.putResult(agent.getIdentString(), String.valueOf(i));
            log.debug((Object)("Puted result " + i));
        }
        this.ab.commit();
        this.ab.startTransaction();
        List<Object> res = this.ab.receiveAgentResults(agent.getIdentString());
        log.debug((Object)("Received " + res.size() + " results"));
        this.ab.commit();
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)String.valueOf(i), (Object)res.get(i));
        }
    }

    @Test
    public void sendReceiveAgent() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        this.ab.commit();
        Agent a2 = this.ab.receiveAgent();
        Assert.assertEquals((Object)agent, (Object)a2);
    }

    @Test
    public void sendReceiveManyAgents() throws DACException {
        int i;
        this.ab.startTransaction();
        for (i = 0; i < 100; ++i) {
            this.ab.sendAgent(new AgentStub());
        }
        this.ab.commit();
        for (i = 0; i < 100; ++i) {
            this.ab.receiveAgent();
        }
    }

    @Test
    public void emptySession() {
        AgentStub agent = new AgentStub();
        Assert.assertNull((Object)agent.getSession());
    }

    @Test
    public void newSessionAfterReceive() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        this.ab.commit();
        this.ab.startTransaction();
        Agent a2 = this.ab.receiveAgent();
        Assert.assertEquals((Object)agent.getIdentString(), (Object)a2.getSession().getSessionId());
        this.ab.commit();
    }

    @Test
    public void newSessionAfterSend() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        Assert.assertEquals((Object)agent.getIdentString(), (Object)agent.getSession().getSessionId());
        this.ab.commit();
    }

    @Test(expected=DACException.class)
    public void invalidSession() throws DACException {
        AgentStub agent = new AgentStub();
        AgentStub secondAgent = new AgentStub();
        secondAgent.setSession(new SessionInfo(secondAgent.getIdentString()));
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        this.ab.sendAgent(secondAgent);
        this.ab.commit();
    }

    @Test
    public void differentSessions() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        this.ab.commit();
        AgentStub secondAgent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(secondAgent);
        this.ab.commit();
        Assert.assertFalse((boolean)agent.getSession().getSessionId().equals(secondAgent.getSession().getSessionId()));
    }

    @Test(expected=DACException.class)
    public void twoTheSameSessions() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        this.ab.commit();
        agent.setSession(null);
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        this.ab.commit();
    }

    @Test
    public void endSessionAfterReceiveAgent() throws DACException {
        this.ab.startTransaction();
        AgentStub agent = new AgentStub();
        this.ab.sendAgent(agent);
        this.ab.commit();
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((Object)agent.toString(), (Object)this.ab.listWaitingAgents(agent.getIdentString()).get(0));
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
        this.ab.receiveAgent();
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test
    public void endSessionWithoutReceiveAgent() throws DACException {
        this.ab.startTransaction();
        AgentStub agent = new AgentStub();
        this.ab.sendAgent(agent);
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
        this.ab.commit();
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((Object)agent.toString(), (Object)this.ab.listWaitingAgents(agent.getIdentString()).get(0));
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test
    public void endSessionAfterReceiveAgentResults() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.putResult(agent.getIdentString(), this.testValue);
        this.ab.commit();
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((Object)this.testValue, (Object)this.ab.listPendingResults(agent.getIdentString()).get(0));
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
        Assert.assertEquals(Arrays.asList(this.testValue), this.ab.receiveAgentResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test
    public void endSessionWithoutReceiveAgentResults() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.putResult(agent.getIdentString(), this.testValue);
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
        this.ab.commit();
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((Object)this.testValue, (Object)this.ab.listPendingResults(agent.getIdentString()).get(0));
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test
    public void emptyTransaction() throws DACException {
        this.ab.startTransaction();
        this.ab.commit();
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test(expected=RuntimeException.class)
    public void notImplementedGetNumberOfWaitingAgents() throws DACException {
        this.ab.getBrokerInfo().getNumberOfWaitingAgents("sessionID");
    }

    @Test(expected=RuntimeException.class)
    public void notImplementedGetNumberOfPendingResults() throws DACException {
        this.ab.getBrokerInfo().getNumberOfPendingResults("sessionID");
    }

    @Test(expected=RuntimeException.class)
    public void notImplementedListWaitingAgents() throws DACException {
        this.ab.getBrokerInfo().listWaitingAgents("sessionID");
    }

    @Test(expected=RuntimeException.class)
    public void notImplementedListPendingResults() throws DACException {
        this.ab.getBrokerInfo().listPendingResults("sessionID");
    }

    @Test
    public void endOneOfTwoSessions() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        this.ab.commit();
        AgentStub secondAgent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(secondAgent);
        this.ab.commit();
        Assert.assertEquals((long)2L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)2L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Object[] expected = new String[]{agent.getIdentString(), secondAgent.getIdentString()};
        Arrays.sort(expected);
        Object[] actual = new String[]{this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0], this.ab.getBrokerInfo().listActiveSessions().get(1).split(" ")[0]};
        Arrays.sort(actual);
        Assert.assertEquals((Object)expected[0], (Object)actual[0]);
        Assert.assertEquals((Object)expected[1], (Object)actual[1]);
        Assert.assertEquals((long)2L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(secondAgent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(secondAgent.getIdentString()).size());
        Assert.assertEquals((long)2L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((Object)agent.toString(), (Object)this.ab.listWaitingAgents(agent.getIdentString()).get(0));
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfWaitingAgents(secondAgent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listWaitingAgents(secondAgent.getIdentString()).size());
        Assert.assertEquals((Object)secondAgent.toString(), (Object)this.ab.listWaitingAgents(secondAgent.getIdentString()).get(0));
        Assert.assertEquals((long)2L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
        this.ab.endSession(agent.getIdentString());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)secondAgent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)2L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(secondAgent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(secondAgent.getIdentString()).size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfWaitingAgents(secondAgent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listWaitingAgents(secondAgent.getIdentString()).size());
        Assert.assertEquals((Object)secondAgent.toString(), (Object)this.ab.listWaitingAgents(secondAgent.getIdentString()).get(0));
        Assert.assertEquals((long)2L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test(expected=DACException.class)
    public void endSessionTwice() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        this.ab.commit();
        this.ab.endSession(agent.getIdentString());
        this.ab.endSession(agent.getIdentString());
    }

    @Test(expected=DACException.class)
    public void endSessionWhenNoSessionsAtAll() throws DACException {
        this.ab.endSession("SessionId");
    }

    @Test(expected=DACException.class)
    public void endInvalidSession() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        this.ab.commit();
        this.ab.endSession("SessionId");
    }

    @Test
    public void endSessionAfterReceiveOneOfTwoAgents() throws DACException {
        this.ab.startTransaction();
        AgentStub agent = new AgentStub();
        this.ab.sendAgent(agent);
        this.ab.commit();
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((Object)agent.toString(), (Object)this.ab.listWaitingAgents(agent.getIdentString()).get(0));
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
        this.ab.startTransaction();
        this.ab.receiveAgent();
        AgentStub agent2 = new AgentStub();
        this.ab.sendAgent(agent2);
        this.ab.commit();
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((Object)agent2.toString(), (Object)this.ab.listWaitingAgents(agent.getIdentString()).get(0));
        Assert.assertEquals((long)2L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test(expected=DACException.class)
    public void startTwoTransactions() throws DACException {
        this.ab.startTransaction();
        this.ab.startTransaction();
    }

    @Test(expected=DACException.class)
    public void commitWithoutStartTransaction() throws DACException {
        this.ab.commit();
    }

    @Test(expected=DACException.class)
    public void rollbackWithoutStartTransaction() throws DACException {
        this.ab.rollback();
    }

    @Test
    public void twoNormalTransactions() throws DACException {
        this.ab.startTransaction();
        this.ab.commit();
        this.ab.startTransaction();
        this.ab.commit();
    }

    @Test
    public void twoTransactionsWithRollback() throws DACException {
        this.ab.startTransaction();
        this.ab.rollback();
        this.ab.startTransaction();
        this.ab.commit();
    }

    @Test
    public void putResultsWithRollback() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.putResult(agent.getIdentString(), this.testValue);
        this.ab.rollback();
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test
    public void sendAgentWithRollback() throws DACException {
        this.ab.startTransaction();
        AgentStub agent = new AgentStub();
        this.ab.sendAgent(agent);
        this.ab.rollback();
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test
    public void receiveAgentWithRollback() throws DACException {
        this.ab.startTransaction();
        AgentStub agent = new AgentStub();
        this.ab.sendAgent(agent);
        this.ab.commit();
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((Object)agent.toString(), (Object)this.ab.listWaitingAgents(agent.getIdentString()).get(0));
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
        this.ab.startTransaction();
        this.ab.receiveAgent();
        this.ab.rollback();
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((Object)agent.toString(), (Object)this.ab.listWaitingAgents(agent.getIdentString()).get(0));
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test
    public void receiveAgentResultsWithRollback() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.putResult(agent.getIdentString(), this.testValue);
        this.ab.commit();
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((Object)this.testValue, (Object)this.ab.listPendingResults(agent.getIdentString()).get(0));
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
        this.ab.startTransaction();
        Assert.assertEquals(Arrays.asList(this.testValue), this.ab.receiveAgentResults(agent.getIdentString()));
        this.ab.rollback();
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((Object)this.testValue, (Object)this.ab.listPendingResults(agent.getIdentString()).get(0));
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }
}

