/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import gnu.cajo.utils.ItemServer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.dacframe.Agent;
import org.dacframe.DACException;
import org.dacframe.MissingClassException;
import org.dacframe.broker.AgentBrokerCajo;
import org.dacframe.broker.AgentBrokerStub;
import org.dacframe.broker.BrokerInfo;
import org.dacframe.broker.SerializationUtils;

public class CajoBrokerServer
implements AgentBrokerCajo {
    private static final Logger log;
    private gnu.cajo.invoke.Remote rmt;
    private final AgentBrokerStub localBroker;
    private Map<String, URLClassLoader> sessionToClassLoaderMap = new HashMap<String, URLClassLoader>();

    public CajoBrokerServer(String hostName) throws UnknownHostException, RemoteException {
        this(hostName, 1198, "broker");
    }

    public CajoBrokerServer(String hostName, int portNo, String bindName) throws UnknownHostException, RemoteException {
        this.localBroker = new AgentBrokerStub(hostName + "/" + portNo + "/" + bindName);
        log.info((Object)("Starting server.. (hostName=" + hostName + ", port=" + portNo + ", name=" + bindName + ")"));
        gnu.cajo.invoke.Remote.config((String)hostName, (int)portNo, null, (int)0);
        this.rmt = ItemServer.bind((Object)this, (String)bindName);
        log.info((Object)"..Done");
        ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout());
        log.addAppender((Appender)appender);
        log.info((Object)("Listening at: //" + gnu.cajo.invoke.Remote.getClientHost() + ":" + gnu.cajo.invoke.Remote.getClientPort() + "/broker"));
        log.removeAppender((Appender)appender);
    }

    public static void main(String[] args) throws UnknownHostException, RemoteException {
        CajoBrokerServer broker = args.length > 0 ? new CajoBrokerServer(args[0]) : new CajoBrokerServer(null);
        broker.localBroker.registerMBean();
    }

    public void cleanup() {
        try {
            gnu.cajo.invoke.Remote.unexportObject((Remote)this.rmt, (boolean)true);
            log.info((Object)"unregistered!");
        }
        catch (NoSuchObjectException e) {
            log.error((Object)e);
        }
    }

    @Override
    public void commit(long transactionId, String sessionId) throws DACException {
        this.localBroker.commit(transactionId, sessionId);
    }

    @Override
    public void rollback(long transactionId, String sessionId) throws DACException {
        this.localBroker.rollback(transactionId, sessionId);
    }

    @Override
    public long createTransaction() {
        return this.localBroker.createTransaction();
    }

    @Override
    public void putResult(String sessionId, String addresseeIdentString, Object result) throws DACException {
        this.localBroker.putResult(sessionId, addresseeIdentString, result);
    }

    @Override
    public void putResult(long transactionId, String sessionId, String addresseeIdentString, Object result) throws DACException {
        this.localBroker.putResult(transactionId, sessionId, addresseeIdentString, result);
    }

    @Override
    public List<Object> receiveAgentResults(long transactionId, String recipientIdentString) throws DACException {
        return this.localBroker.receiveAgentResults(transactionId, recipientIdentString);
    }

    @Override
    public List<Object> receiveAgentResults(long transactionId, String recipientIdentString, int requiredResults) throws DACException {
        return this.localBroker.receiveAgentResults(transactionId, recipientIdentString, requiredResults);
    }

    @Override
    public void sendAgent(String sessionId, long transactionId, byte[] a, int priority) throws DACException {
        Agent agent;
        URLClassLoader classLoader = this.sessionToClassLoaderMap.get(sessionId);
        if (classLoader == null) {
            classLoader = SerializationUtils.createNewUrlClassLoader(sessionId);
            this.sessionToClassLoaderMap.put(sessionId, classLoader);
        }
        try {
            agent = (Agent)SerializationUtils.byteArrayToObject(a, classLoader);
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MissingClassException(SerializationUtils.extractClassName(e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            throw new MissingClassException(SerializationUtils.extractClassName(e.getMessage()));
        }
        this.localBroker.sendAgent(transactionId, agent, priority);
    }

    @Override
    public void sendClassDef(String sessionId, String className, byte[] classDef) throws DACException {
        Set<String> newClasses = SerializationUtils.storeClassDefinition(sessionId, className, classDef);
        ArrayList<String> missingClasses = new ArrayList<String>();
        URLClassLoader classLoader = SerializationUtils.createNewUrlClassLoader(sessionId);
        this.sessionToClassLoaderMap.put(sessionId, classLoader);
        for (String newClassName : newClasses) {
            try {
                classLoader.loadClass(newClassName);
            }
            catch (ClassNotFoundException e) {
                missingClasses.add(newClassName);
            }
        }
        if (missingClasses.size() > 0) {
            throw new MissingClassException(missingClasses);
        }
    }

    @Override
    public byte[] getClassDef(String sessionId, String className) throws DACException {
        try {
            return SerializationUtils.loadClassDef(className, this.sessionToClassLoaderMap.get(sessionId));
        }
        catch (IOException e) {
            throw new DACException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSessionJar(String sessionId) throws DACException {
        File jarFile;
        CajoBrokerServer cajoBrokerServer = this;
        synchronized (cajoBrokerServer) {
            jarFile = new File(System.getProperty("org.dacframe.class.repository", ".sessions") + File.separator + sessionId + ".jar");
            if (!jarFile.exists()) {
                try {
                    List<File> files = this.listSessionFiles(sessionId);
                    if (files.size() == 0) {
                        return null;
                    }
                    this.createJarArchive(jarFile, files, jarFile.getAbsolutePath().length() - 3);
                }
                catch (IOException e) {
                    throw new DACException(e);
                }
            }
        }
        try {
            int read;
            InputStream is = jarFile.toURI().toURL().openStream();
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            byte[] buffer = new byte[3000];
            do {
                if ((read = is.read(buffer, 0, buffer.length)) <= 0) continue;
                buf.write(buffer, 0, read);
            } while (read >= 0);
            is.close();
            return buf.toByteArray();
        }
        catch (IOException e) {
            throw new DACException(e);
        }
    }

    @Override
    public Object[] receiveAgent(long transactionId) throws DACException {
        byte[] byteArray;
        Agent agent = this.localBroker.receiveAgent(transactionId);
        try {
            byteArray = SerializationUtils.objectToByteArray(agent);
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        return new Object[]{agent.getSession().getSessionId(), byteArray};
    }

    @Override
    public void putResult(String sessionId, long transactionId, String addresseeIdentString, byte[] resultBytes) throws DACException {
        Object result;
        URLClassLoader classLoader = this.sessionToClassLoaderMap.get(sessionId);
        if (classLoader == null) {
            classLoader = SerializationUtils.createNewUrlClassLoader(sessionId);
            this.sessionToClassLoaderMap.put(sessionId, classLoader);
        }
        try {
            result = SerializationUtils.byteArrayToObject(resultBytes, classLoader);
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MissingClassException(SerializationUtils.extractClassName(e.getMessage()));
        }
        catch (NoClassDefFoundError e) {
            throw new MissingClassException(SerializationUtils.extractClassName(e.getMessage()));
        }
        this.localBroker.putResult(transactionId, sessionId, addresseeIdentString, result);
    }

    @Override
    public Object[] receiveAgentByteResults(long transactionId, String recipientIdentString) throws DACException {
        byte[] byteArray;
        List<Object> result = this.localBroker.receiveAgentResults(transactionId, recipientIdentString);
        try {
            byteArray = SerializationUtils.objectToByteArray(result);
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        return new Object[]{this.localBroker.getSessionId(transactionId), byteArray};
    }

    @Override
    public Object[] receiveAgentByteResults(long transactionId, String recipientIdentString, int requiredResults) throws DACException {
        byte[] byteArray;
        List<Object> result = this.localBroker.receiveAgentResults(transactionId, recipientIdentString, requiredResults);
        try {
            byteArray = SerializationUtils.objectToByteArray(result);
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        return new Object[]{this.localBroker.getSessionId(transactionId), byteArray};
    }

    @Override
    public BrokerInfo getBrokerInfo() {
        return this.localBroker.getBrokerInfo();
    }

    @Override
    public int getNumberOfPendingResults(String sessionId) throws DACException {
        return this.localBroker.getNumberOfPendingResults(sessionId);
    }

    @Override
    public int getNumberOfWaitingAgents(String sessionId) throws DACException {
        return this.localBroker.getNumberOfWaitingAgents(sessionId);
    }

    @Override
    public List<String> listPendingResults(String sessionId) throws DACException {
        return this.localBroker.listPendingResults(sessionId);
    }

    @Override
    public List<String> listWaitingAgents(String sessionId) throws DACException {
        return this.localBroker.listWaitingAgents(sessionId);
    }

    @Override
    public void endSession(String sessionId) throws DACException {
        this.localBroker.endSession(sessionId);
    }

    public void registerMBean() {
        this.localBroker.registerMBean();
    }

    protected void createJarArchive(File archiveFile, List<File> tobeJared, int offset) throws IOException {
        byte[] buffer = new byte[10240];
        FileOutputStream stream = new FileOutputStream(archiveFile);
        JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());
        for (File aTobeJared : tobeJared) {
            int nRead;
            if (aTobeJared == null || !aTobeJared.exists() || aTobeJared.isDirectory()) continue;
            JarEntry jarAdd = new JarEntry(aTobeJared.getAbsolutePath().substring(offset).replace('\\', '/'));
            jarAdd.setTime(aTobeJared.lastModified());
            out.putNextEntry(jarAdd);
            FileInputStream in = new FileInputStream(aTobeJared);
            while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, nRead);
            }
            in.close();
        }
        out.close();
        stream.close();
    }

    private List<File> listSessionFiles(String sessionId) {
        ArrayList<File> toReturn = new ArrayList<File>();
        File dir = new File(System.getProperty("org.dacframe.class.repository", ".sessions") + File.separator + sessionId);
        this.addFilesToReturn(dir, toReturn);
        return toReturn;
    }

    private void addFilesToReturn(File dir, List<File> toReturn) {
        if (dir.listFiles() != null) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.addFilesToReturn(file, toReturn);
                    continue;
                }
                toReturn.add(file);
            }
        }
    }

    static {
        LogLog.setQuietMode((boolean)true);
        log = Logger.getLogger(CajoBrokerServer.class);
    }
}

