/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import gnu.cajo.utils.extra.TransparentItemProxy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.dacframe.Agent;
import org.dacframe.AgentBroker;
import org.dacframe.DACException;
import org.dacframe.MissingClassException;
import org.dacframe.broker.AgentBrokerCajo;
import org.dacframe.broker.AgentExecutorService;
import org.dacframe.broker.BrokerInfo;
import org.dacframe.broker.CajoBrokerServer;
import org.dacframe.broker.SerializationUtils;
import org.dacframe.cs.CacheServiceHM;
import org.dacframe.session.SessionInfo;
import org.dacframe.worker.WorkerSingleThreaded;

public class CajoBroker
implements AgentBroker {
    private static final Logger log = Logger.getLogger(CajoBroker.class);
    private AgentBrokerCajo broker;
    private SessionInfo currentSession;
    private long currentTransactionId;
    private String brokerURL;
    private String urlForLazyInitialization;
    private Map<String, URLClassLoader> sessionToClassLoaderMap = new HashMap<String, URLClassLoader>();

    public CajoBroker(String brokerURL) throws NotBoundException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InterruptedException {
        this.brokerURL = brokerURL;
        try {
            this.broker = (AgentBrokerCajo)TransparentItemProxy.getItem((String)brokerURL, (Class[])new Class[]{AgentBrokerCajo.class});
        }
        catch (ConnectException e) {
            if (this.brokerURLNotFeasible(brokerURL)) {
                throw e;
            }
            this.urlForLazyInitialization = brokerURL;
            ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout());
            log.addAppender((Appender)appender);
            log.info((Object)"Unable to connect to broker - schedule lazy initialization");
            log.removeAppender((Appender)appender);
        }
    }

    @Override
    public void commit() throws DACException {
        if (this.currentTransactionId == 0L) {
            throw new DACException("There is no active transaction");
        }
        if (this.currentSession != null) {
            this.broker.commit(this.currentTransactionId, this.currentSession.getSessionId());
        } else {
            this.broker.commit(this.currentTransactionId, null);
        }
        this.currentSession = null;
        this.currentTransactionId = 0L;
    }

    @Override
    public void putResult(String addresseeIdentString, Object result) throws DACException {
        block7: {
            this.initDefaultEnvironment();
            if (this.currentSession != null) {
                byte[] byteArray;
                try {
                    byteArray = SerializationUtils.objectToByteArray(result);
                }
                catch (IOException e) {
                    throw new DACException(e);
                }
                while (true) {
                    try {
                        this.broker.putResult(this.currentSession.getSessionId(), this.currentTransactionId, addresseeIdentString, byteArray);
                        break block7;
                    }
                    catch (MissingClassException e) {
                        this.sendMissingClasses(this.currentSession.getSessionId(), e);
                        continue;
                    }
                    catch (Exception e) {
                        throw new DACException(e);
                    }
                    break;
                }
            }
            this.broker.putResult(this.currentTransactionId, null, addresseeIdentString, result);
            this.currentSession = new SessionInfo(addresseeIdentString);
        }
    }

    @Override
    public Agent receiveAgent() throws DACException {
        Agent agent;
        Object[] receiveAgentResult = this.broker.receiveAgent(this.currentTransactionId);
        String sessionId = (String)receiveAgentResult[0];
        byte[] byteArray = (byte[])receiveAgentResult[1];
        URLClassLoader classLoader = this.sessionToClassLoaderMap.get(sessionId);
        if (classLoader == null) {
            File sessionDir = new File(System.getProperty("org.dacframe.class.repository", ".sessions") + File.separator + sessionId + File.separator);
            sessionDir.mkdirs();
            byte[] jarDef = this.broker.getSessionJar(sessionId);
            classLoader = jarDef != null ? SerializationUtils.createNewJarClassLoader(SerializationUtils.storeSessionJar(sessionId, jarDef)) : new URLClassLoader(new URL[0]);
            this.sessionToClassLoaderMap.put(sessionId, classLoader);
        }
        try {
            agent = (Agent)SerializationUtils.byteArrayToObject(byteArray, classLoader);
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        catch (ClassNotFoundException e) {
            throw new DACException(e);
        }
        this.currentSession = agent.getSession();
        return agent;
    }

    @Override
    public List<Object> receiveAgentResults(String recipientIdentString) throws DACException {
        List results;
        boolean localTransaction = false;
        if (this.currentTransactionId == 0L) {
            this.startLocalTransaction();
            localTransaction = true;
        }
        Object[] receiveAgentResult = this.broker.receiveAgentByteResults(this.currentTransactionId, recipientIdentString);
        String sessionId = (String)receiveAgentResult[0];
        if (this.currentSession == null) {
            this.currentSession = new SessionInfo(sessionId);
        }
        byte[] byteArray = (byte[])receiveAgentResult[1];
        URLClassLoader classLoader = this.sessionToClassLoaderMap.get(sessionId);
        if (classLoader == null) {
            File sessionDir = new File(System.getProperty("org.dacframe.class.repository", ".sessions") + File.separator + sessionId + File.separator);
            sessionDir.mkdirs();
            byte[] jarDef = this.broker.getSessionJar(sessionId);
            classLoader = jarDef != null ? SerializationUtils.createNewJarClassLoader(SerializationUtils.storeSessionJar(sessionId, jarDef)) : new URLClassLoader(new URL[0]);
            this.sessionToClassLoaderMap.put(sessionId, classLoader);
        }
        try {
            results = (List)SerializationUtils.byteArrayToObject(byteArray, classLoader);
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        catch (ClassNotFoundException e) {
            throw new DACException(e);
        }
        if (localTransaction) {
            this.commit();
        }
        return results;
    }

    @Override
    public List<Object> receiveAgentResults(String recipientIdentString, int requiredResults) throws DACException {
        List results;
        boolean localTransaction = false;
        if (this.currentTransactionId == 0L) {
            this.startLocalTransaction();
            localTransaction = true;
        }
        Object[] receiveAgentResult = this.broker.receiveAgentByteResults(this.currentTransactionId, recipientIdentString, requiredResults);
        String sessionId = (String)receiveAgentResult[0];
        if (this.currentSession == null) {
            this.currentSession = new SessionInfo(sessionId);
        }
        byte[] byteArray = (byte[])receiveAgentResult[1];
        URLClassLoader classLoader = this.sessionToClassLoaderMap.get(sessionId);
        if (classLoader == null) {
            File sessionDir = new File(System.getProperty("org.dacframe.class.repository", ".sessions") + File.separator + sessionId + File.separator);
            sessionDir.mkdirs();
            byte[] jarDef = this.broker.getSessionJar(sessionId);
            classLoader = jarDef != null ? SerializationUtils.createNewJarClassLoader(SerializationUtils.storeSessionJar(sessionId, jarDef)) : new URLClassLoader(new URL[0]);
            this.sessionToClassLoaderMap.put(sessionId, classLoader);
        }
        try {
            results = (List)SerializationUtils.byteArrayToObject(byteArray, classLoader);
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        catch (ClassNotFoundException e) {
            throw new DACException(e);
        }
        if (localTransaction) {
            this.commit();
        }
        return results;
    }

    @Override
    public ExecutorService getExecutorService() throws DACException {
        return new AgentExecutorService(this.brokerURL);
    }

    @Override
    public void rollback() throws DACException {
        if (this.currentTransactionId == 0L) {
            throw new DACException("There is no active transaction");
        }
        try {
            this.broker.rollback(this.currentTransactionId, this.currentSession != null ? this.currentSession.getSessionId() : null);
        }
        catch (UndeclaredThrowableException e) {
            log.error((Object)e);
        }
        this.currentSession = null;
        this.currentTransactionId = 0L;
    }

    @Override
    public void sendAgent(Agent a, int priority) throws DACException {
        byte[] byteArray;
        this.initDefaultEnvironment();
        this.checkAndSetSession(a);
        try {
            byteArray = SerializationUtils.objectToByteArray(a);
        }
        catch (IOException e) {
            throw new DACException(e);
        }
        String newSessionId = a.getSession() != null ? a.getSession().getSessionId() : a.getIdentString();
        while (true) {
            try {
                this.broker.sendAgent(newSessionId, this.currentTransactionId, byteArray, priority);
            }
            catch (MissingClassException e) {
                this.sendMissingClasses(newSessionId, e);
                continue;
            }
            break;
        }
        this.checkAndSetCurrentSession(a);
    }

    private void sendMissingClasses(String newSessionId, MissingClassException e) throws DACException {
        try {
            for (String missingClass : e.getMissingClasses()) {
                try {
                    this.broker.sendClassDef(newSessionId, missingClass, SerializationUtils.loadClassDef(missingClass, null));
                }
                catch (MissingClassException e1) {
                    this.sendMissingClasses(newSessionId, e1);
                }
            }
        }
        catch (IOException e1) {
            throw new DACException(e1);
        }
    }

    @Override
    public void sendAgent(Agent a) throws DACException {
        this.sendAgent(a, 0);
    }

    @Override
    public void startTransaction() throws DACException {
        if (this.currentTransactionId != 0L) {
            throw new DACException("Old transaction is still active: " + this.currentTransactionId);
        }
        this.initDefaultEnvironment();
        try {
            this.currentTransactionId = this.broker.createTransaction();
        }
        catch (Exception e) {
            throw new DACException(e);
        }
    }

    private void startLocalTransaction() throws DACException {
        if (this.currentTransactionId != 0L) {
            throw new DACException("Old transaction is still active: " + this.currentTransactionId);
        }
        try {
            this.currentTransactionId = this.broker.createTransaction();
        }
        catch (Exception e) {
            throw new DACException(e);
        }
    }

    private void initDefaultEnvironment() {
        if (this.urlForLazyInitialization != null) {
            String hostName = this.extractHost(this.urlForLazyInitialization);
            int portNo = this.extractPort(this.urlForLazyInitialization);
            String bindName = this.extractName(this.urlForLazyInitialization);
            ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout());
            log.addAppender((Appender)appender);
            log.info((Object)"Scheduled broker initialization:");
            log.info((Object)("   host: " + hostName));
            log.info((Object)("   port: " + portNo));
            log.info((Object)("   name: " + bindName));
            log.removeAppender((Appender)appender);
            BrokerThread cajoServerThread = new BrokerThread(hostName, portNo, bindName);
            cajoServerThread.start();
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
            WorkerSingleThreaded worker = null;
            try {
                this.broker = (AgentBrokerCajo)TransparentItemProxy.getItem((String)this.urlForLazyInitialization, (Class[])new Class[]{AgentBrokerCajo.class});
                worker = new WorkerSingleThreaded();
                worker.setAgentBroker(new CajoBroker(this.urlForLazyInitialization));
                worker.setCacheService(new CacheServiceHM());
            }
            catch (NotBoundException e) {
                log.error((Object)e);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e);
            }
            catch (InstantiationException e) {
                log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
            this.urlForLazyInitialization = null;
            new Thread(worker).start();
        }
    }

    public BrokerInfo getBrokerInfo() {
        return this.broker.getBrokerInfo();
    }

    public int getNumberOfPendingResults(String sessionId) throws DACException {
        return this.broker.getNumberOfPendingResults(sessionId);
    }

    public int getNumberOfWaitingAgents(String sessionId) throws DACException {
        return this.broker.getNumberOfWaitingAgents(sessionId);
    }

    public List<String> listPendingResults(String sessionId) throws DACException {
        return this.broker.listPendingResults(sessionId);
    }

    public List<String> listWaitingAgents(String sessionId) throws DACException {
        return this.broker.listWaitingAgents(sessionId);
    }

    public void endSession(String sessionId) throws DACException {
        this.broker.endSession(sessionId);
    }

    private void checkAndSetSession(Agent a) throws DACException {
        if (this.currentSession != null) {
            if (a.getSession() != null && !this.currentSession.getSessionId().equals(a.getSession().getSessionId())) {
                throw new DACException("Illegal session.");
            }
            a.setSession(this.currentSession);
        }
    }

    private void checkAndSetCurrentSession(Agent a) throws DACException {
        if (a.getSession() == null) {
            a.setSession(new SessionInfo(a.getIdentString()));
        }
        this.currentSession = a.getSession();
    }

    private String extractName(String brokerURL) {
        return brokerURL.substring(brokerURL.lastIndexOf(47) + 1);
    }

    private int extractPort(String brokerURL) {
        return Integer.parseInt(brokerURL.substring(brokerURL.indexOf(58) + 1, brokerURL.lastIndexOf(47)));
    }

    private String extractHost(String brokerURL) {
        return brokerURL.substring(2, brokerURL.indexOf(58));
    }

    private boolean brokerURLNotFeasible(String brokerURL) {
        return brokerURL == null || !brokerURL.startsWith("//") || brokerURL.indexOf(58) == -1 || brokerURL.lastIndexOf(47) < 2;
    }

    static class BrokerThread
    extends Thread {
        private String hostName;
        private int portNo;
        private String bindName;

        BrokerThread(String hostName, int portNo, String bindName) {
            this.hostName = hostName;
            this.portNo = portNo;
            this.bindName = bindName;
        }

        @Override
        public void run() {
            try {
                new CajoBrokerServer(this.hostName, this.portNo, this.bindName).registerMBean();
            }
            catch (UnknownHostException e) {
                log.error((Object)e);
            }
            catch (RemoteException e) {
                log.error((Object)e);
            }
        }
    }
}

