/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import java.io.IOException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.dacframe.DACException;
import org.dacframe.broker.CajoBroker;
import org.dacframe.broker.CajoBrokerServer;
import org.dacframe.broker.TestCallable;
import org.dacframe.broker.TestCallableLong;
import org.dacframe.broker.TestCallableWithException;
import org.dacframe.broker.TestRunnable;
import org.dacframe.broker.TestRunnableLong;
import org.dacframe.broker.TestRunnableX;
import org.dacframe.cs.CacheServiceHM;
import org.dacframe.worker.WorkerSingleThreaded;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AgentExecutorServiceTest {
    private static Logger log = Logger.getLogger(AgentExecutorServiceTest.class);
    private CajoBroker broker;
    private int test = 5;
    private int ile = 2;
    private String url = "//localhost:1198/broker";
    private WorkerSingleThreaded worker;
    private Thread workerThread;
    private CajoBrokerServer cajoServer;
    private Thread cajoServerThread = new Thread(){

        @Override
        public void run() {
            try {
                AgentExecutorServiceTest.this.cajoServer = new CajoBrokerServer("localhost");
            }
            catch (UnknownHostException e) {
                log.error((Object)e);
            }
            catch (RemoteException e) {
                log.error((Object)e);
            }
        }
    };

    @Before
    public void setUp() throws Exception {
        this.cajoServerThread.start();
        Thread.sleep(2500L);
        this.broker = new CajoBroker(this.url);
        this.worker = new WorkerSingleThreaded();
        this.worker.setAgentBroker(new CajoBroker("//localhost:1198/broker"));
        this.worker.setCacheService(new CacheServiceHM());
        this.workerThread = new Thread(this.worker);
        this.workerThread.start();
    }

    @After
    public void tearDown() throws Exception {
        this.worker.setStopWorking(true);
        this.workerThread.interrupt();
        this.cajoServer.cleanup();
    }

    @Test
    public void executorServiceCallable() throws DACException, ExecutionException, InterruptedException {
        ArrayList<Future<Integer>> li = new ArrayList<Future<Integer>>();
        ExecutorService xs = this.broker.getExecutorService();
        for (int i = 0; i < this.ile; ++i) {
            Future<Integer> future = xs.submit(new TestCallable<Integer>(this.test));
            li.add(future);
        }
        int result = 0;
        for (Future future : li) {
            result += ((Integer)future.get()).intValue();
        }
        Assert.assertEquals((long)(this.ile * this.test), (long)result);
    }

    @Test
    public void executorServiceRunnable() throws DACException, ExecutionException, InterruptedException {
        ArrayList li = new ArrayList();
        ExecutorService xs = this.broker.getExecutorService();
        for (int i = 0; i < this.ile; ++i) {
            Future<?> future = xs.submit(new TestRunnable(this.test));
            li.add(future);
        }
        for (Future future : li) {
            Assert.assertEquals(null, future.get());
        }
    }

    @Test
    public void executorServiceRunnableT() throws DACException, ExecutionException, InterruptedException {
        ArrayList<Future<String>> li = new ArrayList<Future<String>>();
        ExecutorService xs = this.broker.getExecutorService();
        for (int i = 0; i < this.ile; ++i) {
            Future<String> future = xs.submit(new TestRunnable(this.test), "completed");
            li.add(future);
        }
        for (Future future : li) {
            Assert.assertEquals((Object)"completed", future.get());
        }
    }

    @Test
    public void executorServiceInvokeAll() throws DACException, InterruptedException, ExecutionException {
        ArrayList<TestCallable<Integer>> collec = new ArrayList<TestCallable<Integer>>();
        collec.add(new TestCallable<Integer>(this.test));
        collec.add(new TestCallable<Integer>(this.test));
        collec.add(new TestCallable<Integer>(this.test));
        ExecutorService xs = this.broker.getExecutorService();
        List future = xs.invokeAll(collec);
        int result = 0;
        for (Future ff : future) {
            result += ((Integer)ff.get()).intValue();
        }
        Assert.assertEquals((long)(collec.size() * this.test), (long)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void executorServiceInvokeAny() throws DACException, ExecutionException, InterruptedException, ClassNotFoundException, IOException, NotBoundException, IllegalAccessException, InstantiationException {
        WorkerSingleThreaded worker = new WorkerSingleThreaded();
        worker.setAgentBroker(new CajoBroker(this.url));
        worker.setCacheService(new CacheServiceHM());
        Thread workerThread = new Thread(worker);
        try {
            workerThread.start();
            ArrayList<TestCallable<Integer>> collec = new ArrayList<TestCallable<Integer>>();
            collec.add(new TestCallableWithException<Integer>(this.test));
            collec.add(new TestCallable<Integer>(this.test));
            collec.add(new TestCallable<Integer>(this.test));
            ExecutorService xs = this.broker.getExecutorService();
            Object result = xs.invokeAny(collec);
            Assert.assertEquals((Object)this.test, result);
        }
        finally {
            worker.setStopWorking(true);
            workerThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void executorServiceInvokeAnyTimeout() throws DACException, ExecutionException, InterruptedException, ClassNotFoundException, IOException, NotBoundException, IllegalAccessException, InstantiationException, TimeoutException {
        WorkerSingleThreaded worker = new WorkerSingleThreaded();
        worker.setAgentBroker(new CajoBroker(this.url));
        worker.setCacheService(new CacheServiceHM());
        Thread workerThread = new Thread(worker);
        try {
            workerThread.start();
            ArrayList<TestCallable> collec = new ArrayList<TestCallable>();
            collec.add(new TestCallableWithException<Integer>(this.test));
            collec.add(new TestCallable<Integer>(this.test));
            ExecutorService xs = this.broker.getExecutorService();
            Object result = xs.invokeAny(collec, 3000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)this.test, result);
        }
        finally {
            worker.setStopWorking(true);
            workerThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void executorServiceInvokeAllTimeout() throws ClassNotFoundException, IOException, NotBoundException, InterruptedException, IllegalAccessException, InstantiationException, DACException, ExecutionException {
        WorkerSingleThreaded worker = new WorkerSingleThreaded();
        worker.setAgentBroker(new CajoBroker(this.url));
        worker.setCacheService(new CacheServiceHM());
        Thread workerThread = new Thread(worker);
        try {
            workerThread.start();
            ArrayList<TestCallable<Integer>> collec = new ArrayList<TestCallable<Integer>>();
            collec.add(new TestCallableWithException<Integer>(this.test));
            collec.add(new TestCallable<Integer>(this.test + 1));
            collec.add(new TestCallable<Integer>(this.test + 1));
            ExecutorService xs = this.broker.getExecutorService();
            List future = xs.invokeAll(collec, 3L, TimeUnit.SECONDS);
            int result = 0;
            for (Future ff : future) {
                if (!ff.isDone()) continue;
                try {
                    result += ((Integer)ff.get()).intValue();
                }
                catch (ExecutionException e) {
                    log.error((Object)e);
                }
            }
            Assert.assertEquals((long)(2 * (this.test + 1)), (long)result);
        }
        finally {
            worker.setStopWorking(true);
            workerThread.interrupt();
        }
    }

    @Test
    public void executorServiceShutdown() throws DACException, ExecutionException, InterruptedException {
        ArrayList<Future<Integer>> li = new ArrayList<Future<Integer>>();
        ExecutorService xs = this.broker.getExecutorService();
        for (int i = 1; i <= 4; ++i) {
            if (i == 3) {
                xs.shutdown();
            }
            try {
                Future<Integer> future = xs.submit(new TestCallable<Integer>(i * this.test));
                li.add(future);
                continue;
            }
            catch (RejectedExecutionException e) {
                log.error((Object)e);
            }
        }
        Assert.assertFalse((boolean)xs.isTerminated());
        Assert.assertTrue((boolean)xs.awaitTermination(1L, TimeUnit.SECONDS));
        int result = 0;
        for (Future future : li) {
            result += ((Integer)future.get()).intValue();
        }
        Assert.assertEquals((long)(3 * this.test), (long)result);
    }

    @Test
    public void executorServiceCallableWithException() throws DACException, ExecutionException, InterruptedException {
        ExecutorService xs = this.broker.getExecutorService();
        Future<Integer> future = xs.submit(new TestCallableWithException<Integer>(this.test));
        try {
            future.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)"java.lang.RuntimeException: Exception from TestCallable.", (Object)e.getMessage());
        }
    }

    @Test
    public void executorServiceShutdownNowCallable() throws DACException, ExecutionException, InterruptedException {
        ArrayList<Future<Integer>> li = new ArrayList<Future<Integer>>();
        ExecutorService xs = this.broker.getExecutorService();
        Thread.sleep(700L);
        for (int i = 0; i < 3; ++i) {
            Future<Integer> future = xs.submit(new TestCallableLong<Integer>(this.test));
            li.add(future);
        }
        List<Runnable> list = xs.shutdownNow();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertFalse((boolean)((Future)li.get(0)).isDone());
    }

    @Test
    public void executorServiceShutdownNowRunnable() throws DACException, ExecutionException, InterruptedException {
        ArrayList li = new ArrayList();
        ExecutorService xs = this.broker.getExecutorService();
        Thread.sleep(700L);
        for (int i = 0; i < 3; ++i) {
            Future<?> future = xs.submit(new TestRunnableLong(this.test));
            li.add(future);
        }
        List<Runnable> list = xs.shutdownNow();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertFalse((boolean)((Future)li.get(0)).isDone());
    }

    @Test
    public void executorServiceExecute() throws DACException, InterruptedException {
        ExecutorService xs = this.broker.getExecutorService();
        xs.execute(new TestRunnableX("testIdentString"));
        Thread.sleep(1000L);
        List<Object> results = this.broker.receiveAgentResults("testIdentString");
        Assert.assertEquals((Object)246, (Object)results.get(0));
    }

    @Test(expected=NullPointerException.class)
    public void executorServiceExecuteNP() throws DACException, InterruptedException {
        ExecutorService xs = this.broker.getExecutorService();
        xs.execute(null);
    }

    @Test(expected=RejectedExecutionException.class)
    public void executorServiceExecuteAfterShutdown() throws DACException, InterruptedException {
        ExecutorService xs = this.broker.getExecutorService();
        xs.shutdownNow();
        xs.execute(new TestRunnableX("testIdentString"));
    }

    @Test(expected=NullPointerException.class)
    public void executorServiceSubmitRunnableNP() throws DACException, ExecutionException, InterruptedException {
        ExecutorService xs = this.broker.getExecutorService();
        xs.submit((Runnable)null);
    }

    @Test(expected=RejectedExecutionException.class)
    public void executorServiceSubmitRunnableAfterShutdown() throws DACException, ExecutionException, InterruptedException {
        ExecutorService xs = this.broker.getExecutorService();
        xs.shutdownNow();
        xs.submit(new TestRunnable(this.test));
    }
}

