/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import java.io.IOException;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.dacframe.DACException;
import org.dacframe.broker.AgentExecutor;
import org.dacframe.broker.CajoBroker;
import org.dacframe.broker.FutureDAC;

public class AgentExecutorService
implements ExecutorService {
    private static Logger log = Logger.getLogger(AgentExecutorService.class);
    private CajoBroker broker;
    private boolean shutdown = false;
    private List<Future> futur = new ArrayList<Future>();
    private List<FutureTask> ables = new ArrayList<FutureTask>();
    private String brokerUrl;

    public AgentExecutorService(String brokerUrl) {
        this.brokerUrl = brokerUrl;
        try {
            this.broker = new CajoBroker(brokerUrl);
        }
        catch (NotBoundException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e);
        }
        catch (InstantiationException e) {
            log.error((Object)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        ArrayList<FutureTask> result = new ArrayList<FutureTask>();
        for (int i = 0; i < this.futur.size(); ++i) {
            if (this.futur.get(i).isDone()) continue;
            result.add(this.ables.get(i));
        }
        int waiting = this.broker.getBrokerInfo().getNumberOfWaitingAgents();
        for (String sess : this.broker.getBrokerInfo().listActiveSessions()) {
            try {
                this.broker.endSession(sess);
            }
            catch (DACException e) {
                log.error((Object)e);
            }
        }
        return result.subList(result.size() - waiting, result.size());
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        if (this.isShutdown()) {
            for (Future f : this.futur) {
                if (f.isDone()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        long start = System.currentTimeMillis();
        long end = TimeUnit.MILLISECONDS.convert(l, timeUnit) + start;
        if (this.isShutdown()) {
            HashSet<Future> doneSet = new HashSet<Future>();
            while (doneSet.size() < this.futur.size() && end - System.currentTimeMillis() > 0L) {
                for (Future f : this.futur) {
                    if (!f.isDone()) continue;
                    doneSet.add(f);
                }
                Thread.sleep(100L);
            }
            return doneSet.size() == this.futur.size();
        }
        return false;
    }

    @Override
    public <T> Future<T> submit(Callable<T> tCallable) {
        AgentExecutor agent = new AgentExecutor(tCallable);
        if (!this.isShutdown()) {
            try {
                this.broker.sendAgent(agent);
            }
            catch (DACException e) {
                log.error((Object)e);
            }
            FutureDAC f = new FutureDAC(this.brokerUrl, agent.getIdentString(), 1);
            this.futur.add(f);
            this.ables.add(new FutureTask<T>(tCallable));
            return f;
        }
        throw new RejectedExecutionException();
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        AgentExecutor agent = new AgentExecutor(runnable);
        if (!this.isShutdown()) {
            try {
                this.broker.sendAgent(agent);
            }
            catch (DACException e) {
                log.error((Object)e);
            }
            FutureDAC<T> f = new FutureDAC<T>(this.brokerUrl, agent.getIdentString(), 3, t);
            this.futur.add(f);
            this.ables.add(new FutureTask<T>(runnable, t));
            return f;
        }
        throw new RejectedExecutionException();
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        AgentExecutor agent = new AgentExecutor(runnable);
        if (!this.isShutdown()) {
            try {
                this.broker.sendAgent(agent);
            }
            catch (DACException e) {
                log.error((Object)e);
            }
            FutureDAC f = new FutureDAC(this.brokerUrl, agent.getIdentString(), 2);
            this.futur.add(f);
            this.ables.add(new FutureTask<Object>(runnable, null));
            return f;
        }
        throw new RejectedExecutionException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) throws InterruptedException {
        ArrayList<Future<T>> res = new ArrayList<Future<T>>();
        for (Callable<T> c : callables) {
            if (this.isShutdown()) continue;
            try {
                AgentExecutor agent = new AgentExecutor(c);
                this.broker.sendAgent(agent);
                FutureDAC f = new FutureDAC(this.brokerUrl, agent.getIdentString(), 1);
                this.futur.add(f);
                this.ables.add(new FutureTask<T>(c));
                res.add(f);
            }
            catch (DACException e) {
                log.error((Object)e);
            }
        }
        return res;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException {
        long start = System.currentTimeMillis();
        long end = TimeUnit.MILLISECONDS.convert(l, timeUnit) + start;
        ArrayList res = new ArrayList();
        for (Callable<T> c : callables) {
            if (this.isShutdown() || end - System.currentTimeMillis() <= 0L) continue;
            try {
                AgentExecutor agentExecutor = new AgentExecutor(c);
                this.broker.sendAgent(agentExecutor);
                FutureDAC f = new FutureDAC(this.brokerUrl, agentExecutor.getIdentString(), 1);
                this.futur.add(f);
                this.ables.add(new FutureTask<T>(c));
                res.add(f);
            }
            catch (DACException dACException) {
                log.error((Object)dACException);
            }
        }
        HashSet<Future> doneSet = new HashSet<Future>();
        while (doneSet.size() < res.size() && end - System.currentTimeMillis() > 0L) {
            for (Future future : res) {
                if (!future.isDone()) continue;
                doneSet.add(future);
            }
            Thread.sleep(100L);
        }
        ArrayList<Future<T>> result = new ArrayList<Future<T>>();
        for (Future s : doneSet) {
            result.add(s);
        }
        return result;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
        ArrayList res = new ArrayList();
        for (Callable<T> c : callables) {
            if (this.isShutdown()) continue;
            try {
                AgentExecutor agent = new AgentExecutor(c);
                this.broker.sendAgent(agent);
                FutureDAC f = new FutureDAC(this.brokerUrl, agent.getIdentString(), 1);
                this.futur.add(f);
                this.ables.add(new FutureTask<T>(c));
                res.add(f);
            }
            catch (DACException e) {
                log.error((Object)e);
            }
        }
        int i = 0;
        while (true) {
            Thread.sleep(100L);
            try {
                return (T)((Future)res.get(i)).get();
            }
            catch (ExecutionException e) {
                Future last = (Future)res.remove(i);
                log.error((Object)e);
                i = (i + 1) % res.size();
                if (res.size() > 0) continue;
                return (T)last.get();
            }
            break;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long start = System.currentTimeMillis();
        long end = TimeUnit.MILLISECONDS.convert(l, timeUnit) + start;
        ArrayList res = new ArrayList();
        for (Callable<T> c : callables) {
            if (this.isShutdown() || end - System.currentTimeMillis() <= 0L) continue;
            try {
                AgentExecutor agent = new AgentExecutor(c);
                this.broker.sendAgent(agent);
                FutureDAC f = new FutureDAC(this.brokerUrl, agent.getIdentString(), 1);
                this.futur.add(f);
                this.ables.add(new FutureTask<T>(c));
                res.add(f);
            }
            catch (DACException e) {
                log.error((Object)e);
            }
        }
        int i = 0;
        while (true) {
            Thread.sleep(100L);
            try {
                return (T)((Future)res.get(i)).get();
            }
            catch (ExecutionException e) {
                Future last = (Future)res.remove(i);
                log.error((Object)e);
                i = (i + 1) % res.size();
                long time = end - System.currentTimeMillis();
                if (res.size() > 0 && time >= 0L) continue;
                if (time < 0L) {
                    throw new TimeoutException();
                }
                return (T)last.get();
            }
            break;
        }
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException();
        }
        try {
            this.broker.sendAgent(new AgentExecutor(runnable));
            this.ables.add(new FutureTask<Object>(runnable, null));
        }
        catch (DACException e) {
            log.error((Object)e);
        }
    }
}

