/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import java.util.ArrayList;
import java.util.Arrays;
import org.dacframe.DACException;
import org.dacframe.agent.AgentStub;
import org.dacframe.broker.AgentBrokerStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AgentBrokerStubTest {
    private String abcValue = "abc";
    private String xyzValue = "xyz";
    AgentBrokerStub ab;

    @Before
    public void setUp() throws Exception {
        this.ab = new AgentBrokerStub();
    }

    @Test
    public void sendReceiveAgent() throws DACException {
        AgentStub a = new AgentStub();
        this.ab.sendAgent(a);
        Assert.assertSame((Object)a, (Object)this.ab.receiveAgent());
    }

    @Test
    public void agentsWithDifferentPriorities() throws DACException {
        AgentStub a1 = new AgentStub();
        AgentStub a2 = new AgentStub();
        this.ab.sendAgent(a1, 1);
        this.ab.sendAgent(a2, 2);
        Assert.assertSame((Object)a2, (Object)this.ab.receiveAgent());
        Assert.assertSame((Object)a1, (Object)this.ab.receiveAgent());
    }

    @Test
    public void agentsWithDifferentPriorities2() throws DACException {
        AgentStub a1 = new AgentStub();
        AgentStub a2 = new AgentStub();
        this.ab.sendAgent(a1, 2);
        this.ab.sendAgent(a2, 1);
        Assert.assertSame((Object)a1, (Object)this.ab.receiveAgent());
        Assert.assertSame((Object)a2, (Object)this.ab.receiveAgent());
    }

    @Test
    public void receiveEmptyResults() throws DACException {
        Assert.assertEquals(new ArrayList(), this.ab.receiveAgentResults(new AgentStub().getIdentString()));
    }

    @Test
    public void receiveSomeResults() throws DACException {
        AgentStub addressee = new AgentStub();
        this.ab.putResult(addressee.getIdentString(), this.abcValue);
        this.ab.putResult(addressee.getIdentString(), this.xyzValue);
        Assert.assertEquals(Arrays.asList(this.abcValue, this.xyzValue), this.ab.receiveAgentResults(addressee.getIdentString()));
    }

    @Test
    public void consumingResults() throws DACException {
        AgentStub addressee = new AgentStub();
        this.ab.putResult(addressee.getIdentString(), this.abcValue);
        this.ab.putResult(addressee.getIdentString(), this.xyzValue);
        this.ab.receiveAgentResults(addressee.getIdentString());
        Assert.assertEquals(new ArrayList(), this.ab.receiveAgentResults(addressee.getIdentString()));
    }

    @Test
    public void gettingDifferentResults() throws DACException {
        AgentStub addressee = new AgentStub();
        this.ab.putResult(addressee.getIdentString(), this.abcValue);
        this.ab.putResult(addressee.getIdentString(), this.xyzValue);
        Assert.assertEquals(new ArrayList(), this.ab.receiveAgentResults(new AgentStub().getIdentString()));
    }

    @Test
    public void noSessions() throws DACException {
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
    }

    @Test
    public void newSessionAfterSendAgent() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.sendAgent(agent);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((Object)agent.toString(), (Object)this.ab.listWaitingAgents(agent.getIdentString()).get(0));
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }

    @Test
    public void newSessionAfterPutResult() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.putResult(null, agent.getIdentString(), this.abcValue);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfActiveSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().listActiveSessions().size());
        Assert.assertEquals((Object)agent.getIdentString(), (Object)this.ab.getBrokerInfo().listActiveSessions().get(0).split(" ")[0]);
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfAllSessions());
        Assert.assertEquals((long)1L, (long)this.ab.getBrokerInfo().getNumberOfPendingResults());
        Assert.assertEquals((long)1L, (long)this.ab.getNumberOfPendingResults(agent.getIdentString()));
        Assert.assertEquals((long)1L, (long)this.ab.listPendingResults(agent.getIdentString()).size());
        Assert.assertEquals((Object)this.abcValue, (Object)this.ab.listPendingResults(agent.getIdentString()).get(0));
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfWaitingAgents());
        Assert.assertEquals((long)0L, (long)this.ab.getNumberOfWaitingAgents(agent.getIdentString()));
        Assert.assertEquals((long)0L, (long)this.ab.listWaitingAgents(agent.getIdentString()).size());
        Assert.assertEquals((long)0L, (long)this.ab.getBrokerInfo().getNumberOfAllAgents());
    }
}

