/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.dacframe.Agent;
import org.dacframe.AgentBroker;
import org.dacframe.DACException;
import org.dacframe.broker.AgentBrokerManaged;
import org.dacframe.broker.AgentBrokerWithSerialization;
import org.dacframe.broker.BrokerInfoSnapshot;
import org.dacframe.broker.QueueElem;
import org.dacframe.broker.TransactionDAC;
import org.dacframe.session.SessionInfo;

public class AgentBrokerStub
implements AgentBrokerManaged,
AgentBroker,
AgentBrokerWithSerialization {
    private static final Logger log;
    private PriorityBlockingQueue<QueueElem> queue = new PriorityBlockingQueue();
    private Map<String, List<Object>> resultsMap = new Hashtable<String, List<Object>>();
    private int enqueueCount = 0;
    private Set<String> uniqueAgentList = new HashSet<String>();
    private Map<String, SessionInfo> sessionMap = new HashMap<String, SessionInfo>();
    private Map<String, String> agentToSessionMap = new HashMap<String, String>();
    private Map<String, Set<Agent>> sessionToAgentMap = new HashMap<String, Set<Agent>>();
    private Map<String, List<Object>> sessionToResultsMap = new HashMap<String, List<Object>>();
    private Map<String, Set<Long>> sessionToTransactionMap = new HashMap<String, Set<Long>>();
    private Map<Long, TransactionDAC> transactionMap = new HashMap<Long, TransactionDAC>();
    private int sessionCounter;
    private int activeSessionCounter;
    private int pendingResponses;
    private String brokerName;
    private long transactionCounter;
    private long transactionLifeTime = Long.parseLong(System.getProperty("org.dacframe.transaction.lifetime", "300000"));
    private BrokerInfo mBean = new BrokerInfo();

    public AgentBrokerStub() {
        this.registerMBean("AgentBroker");
        this.startTransactionThread();
    }

    public AgentBrokerStub(String name) {
        this.brokerName = name;
        this.startTransactionThread();
    }

    private void startTransactionThread() {
        new Timer().schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AgentBrokerStub agentBrokerStub = AgentBrokerStub.this;
                synchronized (agentBrokerStub) {
                    ArrayList<Long> transactionIds = new ArrayList<Long>();
                    for (TransactionDAC transaction : AgentBrokerStub.this.transactionMap.values()) {
                        if (System.currentTimeMillis() - transaction.getCreationTime() <= AgentBrokerStub.this.transactionLifeTime || !transaction.isValidForRollback()) continue;
                        transactionIds.add(transaction.getTransactionId());
                    }
                    for (Long transactionId : transactionIds) {
                        try {
                            AgentBrokerStub.this.rollback(transactionId, null);
                        }
                        catch (DACException e) {
                            log.error((Object)"Exception during transaction rollback", (Throwable)e);
                        }
                    }
                }
            }
        }, 5000L, this.transactionLifeTime);
    }

    void registerMBean() {
        this.registerMBean(this.brokerName);
    }

    private void registerMBean(String name) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("org.dacframe.broker:name=" + name);
            mbs.registerMBean(this.mBean, objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            try {
                mbs.unregisterMBean(objectName);
                mbs.registerMBean(this.mBean, objectName);
            }
            catch (Exception e1) {
                log.error((Object)"Exception during un/registring MBean", (Throwable)e1);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception during registring MBean", (Throwable)e);
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public synchronized void commit(long transactionId, String sessionId) throws DACException {
        TransactionDAC transaction = this.transactionMap.get(transactionId);
        if (transaction == null) {
            throw new DACException("Invalid transaction with id=" + transactionId);
        }
        transaction.commit();
        this.transactionMap.remove(transactionId);
        if (sessionId != null) {
            this.sessionToTransactionMap.get(sessionId).remove(transactionId);
        }
        this.commitSession(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitSession(String sessionId) {
        if (sessionId != null) {
            AgentBrokerStub agentBrokerStub = this;
            synchronized (agentBrokerStub) {
                SessionInfo session = this.sessionMap.get(sessionId);
                if (session != null && this.sessionToAgentMap.get(sessionId).size() == 0 && this.sessionToResultsMap.get(sessionId).size() == 0 && this.sessionToTransactionMap.get(sessionId).size() == 0 && session.getEndTime() == null) {
                    session.setEndTime(new Date());
                    --this.activeSessionCounter;
                }
            }
        }
    }

    @Override
    public synchronized void rollback(long transactionId, String sessionId) throws DACException {
        TransactionDAC transaction = this.transactionMap.get(transactionId);
        if (transaction == null) {
            throw new DACException("Invalid transaction with id=" + transactionId);
        }
        transaction.rollback();
        this.transactionMap.remove(transactionId);
        if (sessionId != null && this.sessionToTransactionMap.get(sessionId) != null) {
            this.sessionToTransactionMap.get(sessionId).remove(transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createTransaction() {
        AgentBrokerStub agentBrokerStub = this;
        synchronized (agentBrokerStub) {
            long transactionId = ++this.transactionCounter;
            this.transactionMap.put(transactionId, new TransactionDAC(transactionId, this));
            return transactionId;
        }
    }

    @Override
    public Agent receiveAgent() {
        QueueElem elem = this.takeAgent();
        return elem != null ? elem.agent : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueueElem takeAgent() {
        try {
            QueueElem elem = this.queue.take();
            Agent agent = elem.agent;
            AgentBrokerStub agentBrokerStub = this;
            synchronized (agentBrokerStub) {
                SessionInfo session = this.sessionMap.get(agent.getSession().getSessionId());
                session.setNumberOfWaitingAgents(session.getNumberOfWaitingAgents() - 1);
                this.sessionToAgentMap.get(session.getSessionId()).remove(agent);
                agent.setSession(session);
                return elem;
            }
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void rollback() {
    }

    @Override
    public void startTransaction() {
    }

    @Override
    public synchronized void putResult(String addresseeIdentString, Object result) throws DACException {
        List<Object> results = this.resultsMap.get(addresseeIdentString);
        if (results == null) {
            this.resultsMap.put(addresseeIdentString, new Vector());
        }
        this.resultsMap.get(addresseeIdentString).add(result);
        ++this.pendingResponses;
    }

    @Override
    public synchronized void putResult(String sessionId, String addresseeIdentString, Object result) throws DACException {
        SessionInfo session;
        this.putResult(addresseeIdentString, result);
        if (sessionId == null) {
            sessionId = addresseeIdentString;
            session = new SessionInfo(sessionId);
            log.info((Object)("New session: " + session));
            if (this.sessionMap.containsKey(session.getSessionId())) {
                throw new DACException("Session " + session + " already exist.");
            }
            ++this.sessionCounter;
            ++this.activeSessionCounter;
            this.sessionMap.put(session.getSessionId(), session);
            this.sessionToAgentMap.put(sessionId, new HashSet());
            ArrayList resultsList = new ArrayList();
            this.sessionToResultsMap.put(sessionId, resultsList);
            this.sessionToTransactionMap.put(sessionId, new HashSet());
        }
        this.sessionToResultsMap.get(sessionId).add(result);
        this.agentToSessionMap.put(addresseeIdentString, sessionId);
        session = this.sessionMap.get(sessionId);
        session.setNumberOfPendingResults(session.getNumberOfPendingResults() + 1);
    }

    @Override
    public void putResult(long transactionId, String sessionId, String addresseeIdentString, Object result) throws DACException {
        if (transactionId == 0L) {
            this.putResult(sessionId, addresseeIdentString, result);
            return;
        }
        TransactionDAC transaction = this.transactionMap.get(transactionId);
        if (transaction == null) {
            throw new DACException("Invalid transaction with id=" + transactionId);
        }
        if (sessionId != null && this.sessionToTransactionMap.get(sessionId) != null) {
            this.sessionToTransactionMap.get(sessionId).add(transactionId);
        }
        transaction.putResult(sessionId, addresseeIdentString, result);
    }

    @Override
    public List<Object> receiveAgentResults(long transactionId, String recipientIdentString) throws DACException {
        if (transactionId == 0L) {
            List<Object> results = this.receiveAgentResults(recipientIdentString);
            this.commitSession(this.agentToSessionMap.get(recipientIdentString));
            return results;
        }
        TransactionDAC transaction = this.transactionMap.get(transactionId);
        if (transaction == null) {
            throw new DACException("Invalid transaction with id=" + transactionId);
        }
        return transaction.receiveAgentResults(this.agentToSessionMap.get(recipientIdentString), recipientIdentString);
    }

    @Override
    public List<Object> receiveAgentResults(long transactionId, String recipientIdentString, int requiredResults) throws DACException {
        if (transactionId == 0L) {
            List<Object> results = this.receiveAgentResults(recipientIdentString, requiredResults);
            this.commitSession(this.agentToSessionMap.get(recipientIdentString));
            return results;
        }
        TransactionDAC transaction = this.transactionMap.get(transactionId);
        if (transaction == null) {
            throw new DACException("Invalid transaction with id=" + transactionId);
        }
        return transaction.receiveAgentResults(this.agentToSessionMap.get(recipientIdentString), recipientIdentString, requiredResults);
    }

    @Override
    public void sendAgent(long transactionId, Agent a, int priority) throws DACException {
        if (transactionId == 0L) {
            this.sendAgent(a, priority);
            return;
        }
        TransactionDAC transaction = this.transactionMap.get(transactionId);
        if (transaction == null) {
            throw new DACException("Invalid transaction with id=" + transactionId);
        }
        if (a.getSession() != null && this.sessionToTransactionMap.get(a.getSession().getSessionId()) != null) {
            this.sessionToTransactionMap.get(a.getSession().getSessionId()).add(transactionId);
        }
        transaction.putAgent(a, priority);
    }

    @Override
    public void sendAgent(long transactionId, Agent a) throws DACException {
        this.sendAgent(transactionId, a, 0);
    }

    @Override
    public Agent receiveAgent(long transactionId) throws DACException {
        if (transactionId == 0L) {
            Agent agent = this.receiveAgent();
            this.commitSession(agent.getSession() != null ? agent.getSession().getSessionId() : null);
            return agent;
        }
        TransactionDAC transaction = this.transactionMap.get(transactionId);
        if (transaction == null) {
            throw new DACException("Invalid transaction with id=" + transactionId);
        }
        return transaction.receiveAgent();
    }

    @Override
    public synchronized List<Object> receiveAgentResults(String recipientIdentString) throws DACException {
        List<Object> res = this.resultsMap.remove(recipientIdentString);
        if (res != null) {
            this.updatePendingResults(recipientIdentString, res);
            return res;
        }
        return new Vector<Object>();
    }

    private void updatePendingResults(String identString, List<Object> res) throws DACException {
        int size = res.size();
        this.pendingResponses -= size;
        String sessionId = this.agentToSessionMap.get(identString);
        if (sessionId != null) {
            SessionInfo session = this.sessionMap.get(sessionId);
            session.setNumberOfPendingResults(session.getNumberOfPendingResults() - size);
            this.sessionToResultsMap.get(session.getSessionId()).removeAll(res);
        }
    }

    @Override
    public synchronized List<Object> receiveAgentResults(String recipientIdentString, int requiredResults) throws DACException {
        List<Object> res;
        while ((res = this.resultsMap.get(recipientIdentString)) == null || res.size() < requiredResults) {
        }
        this.resultsMap.remove(recipientIdentString);
        this.updatePendingResults(recipientIdentString, res);
        return res;
    }

    @Override
    public ExecutorService getExecutorService() throws DACException {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public void sendAgent(Agent a, int priority) throws DACException {
        this.sendAgent(a, priority, -1);
    }

    synchronized void sendAgent(Agent a, int priority, int enqueueCount) throws DACException {
        SessionInfo session;
        if (enqueueCount == -1) {
            enqueueCount = ++this.enqueueCount;
        }
        this.queue.put(new QueueElem(a, -priority, enqueueCount));
        this.uniqueAgentList.add(a.getIdentString());
        if (a.getSession() == null) {
            session = new SessionInfo(a.getIdentString());
            log.info((Object)("New session: " + session));
            if (this.sessionMap.containsKey(session.getSessionId())) {
                throw new DACException("Session " + session + " already exist.");
            }
            ++this.sessionCounter;
            ++this.activeSessionCounter;
            this.sessionMap.put(session.getSessionId(), session);
            HashSet<Agent> agentsSet = new HashSet<Agent>();
            agentsSet.add(a);
            this.sessionToAgentMap.put(session.getSessionId(), agentsSet);
            this.sessionToResultsMap.put(session.getSessionId(), new ArrayList());
            this.sessionToTransactionMap.put(session.getSessionId(), new HashSet());
            a.setSession(session);
        }
        this.agentToSessionMap.put(a.getIdentString(), a.getSession().getSessionId());
        this.sessionToAgentMap.get(a.getSession().getSessionId()).add(a);
        session = this.sessionMap.get(a.getSession().getSessionId());
        session.setNumberOfWaitingAgents(session.getNumberOfWaitingAgents() + 1);
    }

    @Override
    public void sendAgent(Agent a) throws DACException {
        this.sendAgent(a, 0);
    }

    @Override
    public org.dacframe.broker.BrokerInfo getBrokerInfo() {
        return new BrokerInfoSnapshot(this.mBean);
    }

    public Object getSessionId(long transactionId) throws DACException {
        TransactionDAC transaction = this.transactionMap.get(transactionId);
        if (transaction == null) {
            throw new DACException("Invalid transaction with id=" + transactionId);
        }
        return transaction.getSessionId();
    }

    @Override
    public int getNumberOfPendingResults(String sessionId) throws DACException {
        return this.mBean.getNumberOfPendingResults(sessionId);
    }

    @Override
    public int getNumberOfWaitingAgents(String sessionId) throws DACException {
        return this.mBean.getNumberOfWaitingAgents(sessionId);
    }

    @Override
    public List<String> listPendingResults(String sessionId) throws DACException {
        return this.mBean.listPendingResults(sessionId);
    }

    @Override
    public List<String> listWaitingAgents(String sessionId) throws DACException {
        return this.mBean.listWaitingAgents(sessionId);
    }

    @Override
    public void endSession(String sessionId) throws DACException {
        this.mBean.endSession(sessionId);
    }

    static {
        LogLog.setQuietMode((boolean)true);
        log = Logger.getLogger(AgentBrokerStub.class);
    }

    public class BrokerInfo
    implements BrokerInfoMBean {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumberOfActiveSessions() {
            AgentBrokerStub agentBrokerStub = AgentBrokerStub.this;
            synchronized (agentBrokerStub) {
                return AgentBrokerStub.this.activeSessionCounter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumberOfAllSessions() {
            AgentBrokerStub agentBrokerStub = AgentBrokerStub.this;
            synchronized (agentBrokerStub) {
                return AgentBrokerStub.this.sessionCounter;
            }
        }

        @Override
        public int getNumberOfWaitingAgents() {
            return AgentBrokerStub.this.queue.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumberOfAllAgents() {
            AgentBrokerStub agentBrokerStub = AgentBrokerStub.this;
            synchronized (agentBrokerStub) {
                return AgentBrokerStub.this.enqueueCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumberOfPendingResults() {
            AgentBrokerStub agentBrokerStub = AgentBrokerStub.this;
            synchronized (agentBrokerStub) {
                return AgentBrokerStub.this.pendingResponses;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumberOfAllUniqueAgents() {
            AgentBrokerStub agentBrokerStub = AgentBrokerStub.this;
            synchronized (agentBrokerStub) {
                return AgentBrokerStub.this.uniqueAgentList.size();
            }
        }

        @Override
        public int getNumberOfPendingResults(String sessionId) throws DACException {
            SessionInfo sessionInfo = (SessionInfo)AgentBrokerStub.this.sessionMap.get(sessionId);
            if (sessionInfo == null) {
                throw new DACException("Unknown session");
            }
            return sessionInfo.getNumberOfPendingResults();
        }

        @Override
        public int getNumberOfWaitingAgents(String sessionId) throws DACException {
            SessionInfo sessionInfo = (SessionInfo)AgentBrokerStub.this.sessionMap.get(sessionId);
            if (sessionInfo == null) {
                throw new DACException("Unknown session");
            }
            return sessionInfo.getNumberOfWaitingAgents();
        }

        @Override
        public List<String> listActiveSessions() {
            ArrayList<String> toReturn = new ArrayList<String>();
            for (String sessionId : AgentBrokerStub.this.sessionMap.keySet()) {
                if (((SessionInfo)AgentBrokerStub.this.sessionMap.get(sessionId)).getEndTime() != null) continue;
                toReturn.add(((SessionInfo)AgentBrokerStub.this.sessionMap.get(sessionId)).toString());
            }
            return toReturn;
        }

        @Override
        public List<String> listPendingResults(String sessionId) throws DACException {
            ArrayList<String> toReturn = new ArrayList<String>();
            SessionInfo sessionInfo = (SessionInfo)AgentBrokerStub.this.sessionMap.get(sessionId);
            if (sessionInfo == null) {
                throw new DACException("Unknown session");
            }
            for (Object pendingResult : (List)AgentBrokerStub.this.sessionToResultsMap.get(sessionId)) {
                toReturn.add(pendingResult.toString());
            }
            return toReturn;
        }

        @Override
        public List<String> listWaitingAgents(String sessionId) throws DACException {
            ArrayList<String> toReturn = new ArrayList<String>();
            SessionInfo sessionInfo = (SessionInfo)AgentBrokerStub.this.sessionMap.get(sessionId);
            if (sessionInfo == null) {
                throw new DACException("Unknown session");
            }
            for (Agent agent : (Set)AgentBrokerStub.this.sessionToAgentMap.get(sessionId)) {
                toReturn.add(agent.toString());
            }
            return toReturn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endSession(String sessionId) throws DACException {
            SessionInfo sessionInfo = (SessionInfo)AgentBrokerStub.this.sessionMap.get(sessionId);
            if (sessionInfo == null) {
                throw new DACException("Unknown session");
            }
            if (sessionInfo.getEndTime() != null) {
                throw new DACException("Session has been already closed");
            }
            AgentBrokerStub agentBrokerStub = AgentBrokerStub.this;
            synchronized (agentBrokerStub) {
                sessionInfo.setEndTime(new Date());
                sessionInfo.setNumberOfWaitingAgents(0);
                Set agentsSet = (Set)AgentBrokerStub.this.sessionToAgentMap.get(sessionId);
                for (QueueElem elem : AgentBrokerStub.this.queue) {
                    if (!agentsSet.contains(elem.agent)) continue;
                    AgentBrokerStub.this.queue.remove(elem);
                }
                ((Set)AgentBrokerStub.this.sessionToAgentMap.get(sessionId)).clear();
                for (String agentId : AgentBrokerStub.this.resultsMap.keySet()) {
                    if (!((String)AgentBrokerStub.this.agentToSessionMap.get(agentId)).equals(sessionId)) continue;
                    AgentBrokerStub.this.resultsMap.remove(agentId);
                }
                sessionInfo.setNumberOfPendingResults(0);
                ((List)AgentBrokerStub.this.sessionToResultsMap.get(sessionId)).clear();
                AgentBrokerStub.this.activeSessionCounter--;
            }
        }
    }

    public static interface BrokerInfoMBean
    extends org.dacframe.broker.BrokerInfo {
    }
}

