/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import org.apache.activemq.broker.BrokerService;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public final class ActiveMQEmbeddedBroker {
    private static final Logger log = Logger.getLogger(ActiveMQEmbeddedBroker.class);
    private String brokerURL;

    public ActiveMQEmbeddedBroker(String url) {
        this.brokerURL = url;
    }

    public void start() throws Exception {
        log.info((Object)("Starting JMS broker " + this.brokerURL));
        BrokerService broker = new BrokerService();
        broker.setUseJmx(true);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.addConnector(this.brokerURL);
        broker.start();
        ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout());
        log.addAppender((Appender)appender);
        log.info((Object)("JMS broker ready at: " + this.brokerURL));
        log.removeAppender((Appender)appender);
        while (!broker.isStarted()) {
            Thread.sleep(1000L);
        }
        log.info((Object)("Is broker started? " + broker.isStarted()));
    }

    public static void main(String[] args) throws Exception {
        ActiveMQEmbeddedBroker broker = args.length > 0 ? new ActiveMQEmbeddedBroker(args[0]) : new ActiveMQEmbeddedBroker(null);
        broker.start();
    }
}

