/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.broker;

import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.dacframe.Agent;
import org.dacframe.DACException;
import org.dacframe.agent.AgentStub;
import org.dacframe.broker.ActiveMQBroker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActiveMQBrokerTest {
    private static Logger log = Logger.getLogger(ActiveMQBrokerTest.class);
    private ActiveMQBroker ab;

    public ActiveMQBrokerTest() {
        BasicConfigurator.configure();
    }

    @Before
    public void setUp() throws Exception {
        this.ab = new ActiveMQBroker("failover://tcp://localhost:61616");
    }

    @After
    public void tearDown() throws Exception {
        this.ab.cleanup();
    }

    @Test
    public void sendReceiveResult() throws DACException {
        AgentStub agent = new AgentStub();
        Integer result = 222;
        this.ab.startTransaction();
        this.ab.putResult(agent.getIdentString(), result);
        this.ab.commit();
        this.ab.startTransaction();
        List<Object> results = this.ab.receiveAgentResults(agent.getIdentString(), 1);
        this.ab.commit();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)222, (Object)results.get(0));
    }

    @Test
    public void sendReceiveManyResults() throws InterruptedException, DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        for (int i = 0; i < 100; ++i) {
            this.ab.putResult(agent.getIdentString(), String.valueOf(i));
            this.ab.commit();
            log.debug((Object)("Puted result " + i));
        }
        List<Object> res = this.ab.receiveAgentResults(agent.getIdentString(), 100);
        log.debug((Object)("Received " + res.size() + " results"));
        this.ab.commit();
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)String.valueOf(i), (Object)res.get(i));
        }
    }

    @Test
    public void sendReceiveAgent() throws DACException {
        AgentStub agent = new AgentStub();
        this.ab.startTransaction();
        this.ab.sendAgent(agent);
        this.ab.commit();
        Agent a2 = this.ab.receiveAgent();
        assert (a2.equals(agent));
        this.ab.commit();
    }

    @Test
    public void sendReceiveManyAgents() throws DACException {
        int i;
        for (i = 0; i < 100; ++i) {
            this.ab.sendAgent(new AgentStub());
        }
        this.ab.commit();
        for (i = 0; i < 100; ++i) {
            this.ab.receiveAgent();
        }
        this.ab.commit();
    }
}

