/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe.agent;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dacframe.Agent;
import org.dacframe.DACException;

public class ResultsAggregatorAgent
extends Agent {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ResultsAggregatorAgent.class);
    private Agent resultsRecipient;
    private List<Object> aggregated = new ArrayList<Object>();
    private int numberOfResults;

    public ResultsAggregatorAgent(Agent resultsRecipient, int numberOfResults) {
        super(null);
        this.resultsRecipient = resultsRecipient;
        this.numberOfResults = numberOfResults;
        log.debug((Object)("Will aggregate " + numberOfResults + " results for " + resultsRecipient));
    }

    @Override
    public void execute() throws DACException {
        log.debug((Object)("Aggregated so far " + this.aggregated.size() + " results for " + this.resultsRecipient.getIdentString() + ", " + this.numberOfResults + " needed"));
        List<Object> newResults = this.getAgentManager().receiveAgentResults(this.resultsRecipient.getIdentString());
        log.debug((Object)("Received " + newResults + " new results"));
        this.aggregated.addAll(newResults);
        if (this.aggregated.size() == this.numberOfResults) {
            log.debug((Object)"All needed results aggregated");
            this.getAgentManager().putResult(this.resultsRecipient.getIdentString(), this.aggregated);
            this.getAgentManager().sendAgent(this.resultsRecipient);
        } else {
            log.debug((Object)("Sending " + this + " back to broker"));
            this.getAgentManager().sendAgent(this);
        }
    }
}

