/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe;

import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.dacframe.Agent;
import org.dacframe.AgentBroker;
import org.dacframe.DACException;
import org.dacframe.broker.ActiveMQBroker;
import org.dacframe.spring.GaspsApplicationContext;

public class Launcher {
    private static Logger logger;
    private AgentBroker broker;
    private Agent agent;

    public void launch() throws DACException {
        this.broker.startTransaction();
        this.broker.sendAgent(this.agent);
        this.broker.commit();
        ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout());
        logger.addAppender((Appender)appender);
        logger.info((Object)("Agent " + this.agent.getIdentString() + " has been sent"));
        logger.removeAppender((Appender)appender);
        if (this.broker instanceof ActiveMQBroker) {
            ((ActiveMQBroker)this.broker).cleanup();
        }
    }

    public static void main(String[] args) throws DACException {
        Launcher launcher = (Launcher)GaspsApplicationContext.getContext().getBean("launcher");
        launcher.launch();
    }

    public AgentBroker getBroker() {
        return this.broker;
    }

    public void setBroker(AgentBroker broker) {
        this.broker = broker;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    static {
        LogLog.setQuietMode((boolean)true);
        logger = Logger.getLogger(Launcher.class);
    }
}

