/*
 * Decompiled with CFR 0.152.
 */
package org.dacframe;

import java.io.Serializable;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dacframe.AgentManager;
import org.dacframe.CacheService;
import org.dacframe.DACException;
import org.dacframe.session.SessionInfo;

public abstract class Agent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String identString;
    private SessionInfo session;
    private transient CacheService cacheService;
    private transient AgentManager agentManager;
    private transient Logger logger;

    public Agent(String identString) {
        this.identString = identString != null ? identString : UUID.randomUUID().toString();
    }

    public int hashCode() {
        return this.identString.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            return this.getIdentString().equals(((Agent)other).getIdentString());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        return "<" + this.getClass().getName() + " " + this.getIdentString() + ">";
    }

    public String getIdentString() {
        return this.identString;
    }

    protected CacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    protected AgentManager getAgentManager() {
        return this.agentManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public abstract void execute() throws DACException;

    public void setSession(SessionInfo sessionId) {
        this.session = sessionId;
    }

    public SessionInfo getSession() {
        return this.session;
    }
}

